/*
**  Connection.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_Connection
#define _Pantomime_H_Connection

#import <Foundation/NSData.h>
#import <Foundation/NSString.h>

@protocol Connection 

- (void) dealloc;

- (id) initWithName: (NSString *) theName
               port: (int) thePort;

- (id) initWithName: (NSString *) theName
	       port: (int) thePort
  connectionTimeout: (int) theConnectionTimeout
	readTimeout: (int) theReadTimeout
       writeTimeout: (int) theWriteTimeout;


//
// access / mutation methods
//

- (NSString *) name;
- (void) setName: (NSString *) theName;

- (int) port;
- (void) setPort: (int) thePort;

- (int) connectionTimeout;
- (void) setConnectionTimeout: (int) theConnectionTimeout;

- (int) readTimeout;
- (void) setReadTimeout: (int) theReadTimeout;

- (int) writeTimeout;
- (void) setWriteTimeout: (int) theWriteTimeout;

- (int) fd;

- (void) setStopTarget: (id) theTarget;
- (void) setStopSelector: (SEL) theSelector;

//
// other methods
//
- (void) close;

- (NSData *) readDataOfLength: (int) theLength;
- (NSData *) readDataToEndOfLine;

- (NSString *) readStringOfLength: (int) theLength;
- (NSString *) readStringToEndOfLine;
- (NSString *) readStringToEndOfLineSkippingCR: (BOOL) aBOOL;

- (BOOL) writeLine: (NSString *) theLine;

- (BOOL) writeData: (NSData *) theData;
- (BOOL) writeString: (NSString *) theString;

@end

#endif // _Pantomime_H_Connection
