/*
**  Pantomime.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "Pantomime.h"

#import <Pantomime/Parser.h>
#import <Pantomime/LocalStore.h>
#import <Pantomime/LocalFolder.h>
#import <Pantomime/Message.h>
#import <Pantomime/InternetAddress.h>
#import <Pantomime/SMTP.h>
#import <Pantomime/Constants.h>
#import <Pantomime/POP3Store.h>
#import <Pantomime/POP3Folder.h>
#import <Pantomime/IMAPStore.h>
#import <Pantomime/IMAPFolder.h>

#import <Pantomime/MimeMultipart.h>
#import <Pantomime/MimeBodyPart.h>

#import <Pantomime/elm_defs.h>

@implementation Pantomime 

@end

int main(int argc, const char *argv[], char *env[])
{
  if (argc < 3)
    {
      printf("%c[2J", 27);
      printf("Pantomime 0.2.0 Test Program\n");
      printf("----------------------------\n");
      printf("Usage:\n");
      printf("openapp Pantomime.app <operation> <servername / <directory name/mailbox name>> [<username>] [<password>] [<message number>] [<email address>] [<output directory name>]\n\n");
      printf("<operation> : POP3, IMAP, SMTP or Local\n");
      printf("<servername / directory name> : The name of the server for POP3/IMAP/SMTP or\n");
      printf("                                the directory name for Local\n");
      printf("<username>, <password> : Required for POP3 and IMAP\n");
      printf("<message number> : The index of the message you want to show/decode (the first is 0)\n");
      printf("                   for POP3/IMAP or Local.\n");
      printf("<email address> : Required for SMTP\n");
      printf("<output directory name> : The path to the directory where the files decoded will be stored\n\n");
      printf("Examples:\n");
      printf("%% openapp Pantomime.app local /home/ludovic/gnumail/Inbox 50 /tmp/output\n");
      printf("%% openapp Pantomime.app smtp asmtp.server.com bill@microsoft.com\n");
      printf("%% openapp Pantomime.app pop3 apop.server.com bill booboo 0 /tmp/output\n");
      printf("%% openapp Pantomime.app imap animap.server.com bill booboo 0 /tmp/output\n\n");
      
      exit(0);
    }
  else
    {
      // We create our pool for being able to do AUTORELEASE fu
      CREATE_AUTORELEASE_POOL(pool);
      NSLog(@"Created autorelease pool...");
      
      if ( strcasecmp(argv[1], "Local") == 0 )
	{
	  LocalStore *localStore;

	  if (argc != 5) 
	    {
	      NSLog(@"Wrong number of parameters for Local operation.");
	      NSLog(@"Releasing pool...");
	      RELEASE(pool);
	      exit(0);
	    }
	  
	  localStore = [[LocalStore alloc] initWithPathToDirectory: [[NSString stringWithCString: argv[2]] 
								      stringByDeletingLastPathComponent] ];
	  
	  if ( localStore )
	    {
	      LocalFolder *aFolder = [localStore folderForName: [[NSString stringWithCString: argv[2]] 
								  lastPathComponent]];
	      
	      if (aFolder)
		{
		  Message *aMessage;

		  NSLog(@"message count: %d", [aFolder count]);
		  
		  aMessage = [aFolder messageAtIndex: atoi(argv[3])];
		  NSLog(@"From: %@", [[aMessage from] unicodeStringValue]);
		  NSLog(@"Subject: %@", [aMessage subject]);
		  NSLog(@"isInitialized? %d", [aMessage isInitialized]);
		  //NSLog([aMessage rawSource]);
		  [aMessage setInitialized: YES];
		  NSLog(@"isInitialized? %d", [aMessage isInitialized]);
		  NSLog(@"Content-Type: |%@|", [aMessage contentType]);

		  if ( [aMessage isMimeType:@"text":@"*"] )
		    {
		      NSLog( (NSString*)[aMessage content] );
		    }
		  else
		    {
		      MimeMultipart *aMimeMultipart;
		      int i;
		      
		      aMimeMultipart = (MimeMultipart *) [aMessage content];
		      NSLog(@"Multipart count: %d", [aMimeMultipart count]);
		      
		      for ( i = 0; i < [aMimeMultipart count]; i++ )
			{
			  MimeBodyPart *aMimeBodyPart;
			  
			  aMimeBodyPart = [aMimeMultipart bodyPartAtIndex: i];

			  if ( [aMimeBodyPart isMimeType:@"text":@"*"] )
			    {
			      NSLog( (NSString*)[aMimeBodyPart content] );
			    }
			  else
			    {
			      NSData *aData;		   
			      
			      NSLog(@"Processing data...");
			      aData = (NSData *)[aMimeBodyPart content];
			      [aData writeToFile: [NSString stringWithFormat:@"%@/%@", [NSString stringWithCString: argv[4]],
							    [aMimeBodyPart filename]]
				     atomically: YES];
			    }
			  
			} // for (...)
		    }
		}
	      else
		{
		  NSLog(@"Unable to open the folder.");
		}
	      
	      [aFolder close];
	      [localStore close];
	    }
	  else
	    {
	      NSLog(@"Unable to open the local store");
	    }
	}
      
      // We create a test message that we're gonna send
      if ( strcasecmp(argv[1], "SMTP") == 0 )
	{
	  InternetAddress *anInternetAddress;
	  Message *aMessage;
	  SMTP *aSMTP;
	  
	  if (argc != 4) 
	    {
	      NSLog(@"Wrong number of parameters for SMTP operation.");
	      NSLog(@"Releasing pool...");
	      RELEASE(pool);
	      exit(0);
	    }

	  aMessage = [[Message alloc] init];
	  
	  [aMessage setFrom: [[InternetAddress alloc] initWithString: @"Bill <bill@microsoft.com>"]];	
	  
	  anInternetAddress = [[InternetAddress alloc] initWithString: [NSString stringWithCString: argv[3]]];
	  [anInternetAddress setType: TO];
	  [aMessage addToRecipients: anInternetAddress];
	  
	  [aMessage setSubject: @"Pantomime Test!"];
	  
	  // Simple message
	  [aMessage setContentType: @"text/plain"];
	  [aMessage setContentTransferEncoding: NONE];
	  [aMessage setContent: @"This a test message sent by using Pantomime!"];
						       
	  // MIME message with an attachment
	  // TODO
	  aSMTP = [[SMTP alloc] initWithName: [NSString stringWithCString: argv[2]]
				port: 25];
	  
	  if ( [aSMTP sendMessage: aMessage] )
	    {
	      NSLog(@"Sucessfully sent E-Mail!");
	    }
	  else
	    {
	      NSLog(@"Failed to send E-Mail!");
	    }

	  [aSMTP close];
	}
      
      // We connect to a POP3 server to fetch a message
      if ( strcasecmp(argv[1], "POP3") == 0 )
	{
	  POP3Store *aStore;
	  
	  if (argc != 7) 
	    {
	      NSLog(@"Wrong number of parameters for POP3 operation.");
	      NSLog(@"Releasing pool...");
	      RELEASE(pool);
	      exit(0);
	    }

	  aStore = [[POP3Store alloc] initWithName: [NSString stringWithCString: argv[2]]
				      port: 110];
	  
	  if ([aStore authenticateWithUsername: [NSString stringWithCString: argv[3]]
		      password: [NSString stringWithCString: argv[4]]])
	    {
	      POP3Folder *aFolder;
	      Message *aMessage;
	      
	      NSLog(@"Authentication succeeded!");
	      
	      aFolder = (POP3Folder *)[aStore defaultFolder];
	      aMessage = [aFolder messageAtIndex: atoi(argv[5]) ];
	      NSLog(@"From: %@", [[aMessage from] unicodeStringValue]);
	      NSLog(@"Subject: %@", [aMessage subject]);
	      
	      if ( [aMessage isMimeType:@"text":@"*"] )
		{
		  NSLog( (NSString*)[aMessage content] );
		}
	      else
		{
		  MimeMultipart *aMimeMultipart;
		  int i;
		  
		  aMimeMultipart = (MimeMultipart *) [aMessage content];
		  
		  for ( i = 0; i < [aMimeMultipart count]; i++ )
		    {
		      MimeBodyPart *aMimeBodyPart;
		      
		      aMimeBodyPart = [aMimeMultipart bodyPartAtIndex: i];
		      
		      if ( [aMimeBodyPart isMimeType:@"text":@"*"] )
			{
			  NSLog( (NSString*)[aMimeBodyPart content] );
			}
		      else
			{
			  NSData *aData;		      
			  aData = (NSData *)[aMimeBodyPart content];
			  [aData writeToFile: [NSString stringWithFormat:@"%@/%@", [NSString stringWithCString: argv[6]],
							[aMimeBodyPart filename]]
				 atomically: YES];
			}  
		    } // for (...)
		}
	      
	      [aFolder close];
	    }
	  else
	    {
	      NSLog(@"Authentication failed!");
	    }
	  
	  [aStore close];
	}
      
      if ( strcasecmp(argv[1], "IMAP") == 0 )
	{
	  IMAPStore *aStore;

	  if (argc != 7) 
	    {
	      NSLog(@"Wrong number of parameters for IMAP operation.");
	      NSLog(@"Releasing pool...");
	      RELEASE(pool);
	      exit(0);
	    }
	  
  	  aStore = [[IMAPStore alloc] initWithName: [NSString stringWithCString: argv[2]]
  				      port: 143];
	  
 	  if ([aStore authenticateWithUsername: [NSString stringWithCString: argv[3]]
  		      password: [NSString stringWithCString: argv[4]]])
  	    { 
  	      IMAPFolder *aFolder;
	      
  	      NSLog(@"Authentication succeeded!");
	      
  	      aFolder = (IMAPFolder *)[aStore defaultFolder];
	      
  	      if ( aFolder ) 
  		{
  		  Message *aMessage;

  		  aMessage = (Message *)[aFolder messageAtIndex: atonum(argv[5]) ];
		  [aMessage setInitialized: YES];

  		  NSLog(@"From: %@", [[aMessage from] unicodeStringValue]);
 		  NSLog(@"Subject: %@", [aMessage subject]);
		  
  		  if ( [aMessage isMimeType:@"text":@"*"] )
		    {
		      NSLog( (NSString*)[aMessage content] );
		    }
		  else
		    {
		      MimeMultipart *aMimeMultipart;
		      int i;
		      
		      aMimeMultipart = (MimeMultipart *) [aMessage content];
		      
		      for ( i = 0; i < [aMimeMultipart count]; i++ )
			{
			  MimeBodyPart *aMimeBodyPart;
			  
			  aMimeBodyPart = [aMimeMultipart bodyPartAtIndex: i];
			  
			  if ( [aMimeBodyPart isMimeType:@"text":@"*"] )
			    {
			      NSLog( (NSString*)[aMimeBodyPart content] );
			    }
			  else
			    {
			      NSData *aData;		      
			      aData = (NSData *)[aMimeBodyPart content];
			      [aData writeToFile: [NSString stringWithFormat:@"%@/%@", [NSString stringWithCString: argv[6]],
							    [aMimeBodyPart filename]]
				     atomically: YES];
			    }  
			} // for (...)
		    }
		  
  		  [aFolder close];
 		}
  	    }
  	  else
  	    {
  	      NSLog(@"Authentication failed!");
  	    }
	  
	  
  	  [aStore close];
	}
      
      NSLog(@"Releasing pool...");
      RELEASE(pool);
      
      exit(0);

    } // else ...
}
