/*
**  IMAPFolder.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**          Anthony W. Juckel <awj@digitalgreen.com>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#import <Foundation/Foundation.h>
#import <Pantomime/Folder.h>

#import <sys/types.h>
#import <sys/socket.h>
#import <netinet/in.h>
#import <netdb.h>

@class Flags;
@class IMAPCacheManager;

@interface IMAPFolder : Folder
{
  int uidValidity;
  IMAPCacheManager *imapCacheManager;
}

- (void) deleteMessageWithUID: (int) theUID;

- (NSData *) prefetchMessageWithUID: (int) theUID;
- (NSData *) prefetchMessageBodyWithUID: (int) theUID;
- (NSData *) prefetchMessageHeadersWithUID: (int) theUID;

- (BOOL) prefetch;
- (BOOL) prefetchNewMessagesStartingAtUID: (int) theUID;
- (NSDictionary *) prefetchMessageFlagsFromUID: (int) startUID toUID: (int) endUID;

- (Flags *) fetchMessageFlagsWithUID: (int) theUID;
- (int) fetchMessageSizeWithUID: (int) theUID;
- (int) fetchMessageMSNWithUID: (int) theUID;

- (Flags *) parseMessageFlagsFromString: (NSString *) aString;
- (int) parseMessageSizeFromString: (NSString *) aString;
- (int) parseMessageMSNFromString: (NSString *) aString;
- (int) parseMessageSegmentSizeFromString: (NSString *) aString;
- (int) parseMessageUIDFromString: (NSString *) aString;

- (NSArray *) uncachedUIDStartingAtUID: (int) theUID;

- (void) setMessageFlags: (Flags *) theFlags
                  forUID: (int) theUID;

- (void) noop;

- (int) uidValidity;
- (void) setUIDValidity: (int) theUIDValidity;


- (IMAPCacheManager *) imapCacheManager;
- (void) setIMAPCacheManager: (IMAPCacheManager *) theIMAPCacheManager;

@end

@interface IMAPFolder (Private)

- (void) _replaceCRLFInMutableData: (NSMutableData *) theMutableData;

@end
