/*
 * Pan - A Newsreader for X
 * Copyright (C) 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __IDENTITY_H__
#define __IDENTITY_H__

#include <glib.h>

#include <pan/base/pan-object.h>

#define IDENTITY(x) ((Identity*)(x))
#define HEADER(x)   ((Header*)(x))

typedef struct _Header Header;

struct _Header
{
	gchar * name;
	gchar * value;
};

typedef struct _Identity Identity;

struct _Identity
{
	/* Parent */
	PanObject parent;

	/* Fields */
	gchar     * name;

	gchar     * author_real;
	gchar     * author_addr;
	gchar     * signature;
	gchar     * organization;
	gchar     * reply_to;
	gchar     * attribution;
	gchar     * msg_id_fqdn;
	GPtrArray * custom_headers;
};

/**
*** Public 
**/

Identity * identity_new (void);

Identity * identity_dup (const Identity * id);

void       identity_set_name         (Identity * id, const gchar * name);
void       identity_set_author_real  (Identity * id, const gchar * real);
void       identity_set_author_addr  (Identity * id, const gchar * addr);
void       identity_set_reply_to     (Identity * id, const gchar * addr);
void       identity_set_organization (Identity * id, const gchar * org);
void       identity_set_signature    (Identity * id, const gchar * sig);
void       identity_set_attribution  (Identity * id, const gchar * attrib);
void       identity_set_msg_id_fqdn  (Identity * id, const gchar * msg_id_fqdn);

gboolean   identity_is_valid         (const Identity *);

/**
***  Protected
**/ 

void       identity_constructor (Identity            * identity);
void       identity_destructor  (PanObject           * identity);

#endif

