
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    md_http.h
**  Date:    July 17, 2003
**
**  Author:  Brian Wotring
**  Purpose: http management routines.
**
******************************************************************************/

#ifndef MD_HTTP_H_
#define MD_HTTP_H_

void process_http_message( SSL *ssl, const char *http_message );
void process_http_update_host( SSL *ssl,const char *host, const char *base_db );

void process_http_view_host( SSL *ssl, const char *host, const char *base_db,
                             const char *logname );

void send_http_response( SSL *ssl, const char *response );

osi_bool http_request_is_authorized( const char *http_message );
void decode_base64_string( char *source, char *dest, int dest_size );


#endif
