#############################################################################
#
#  Retrieving Windows Registry Related Queries
#
#  Copyright: SecPod
#
#  Date Written: 2008/07/18
#
# Updated: 2009/04/23
# Chandan S <schandan@secpod.com>
#
#  Revision: 1.2 
#
#  Log: schandan
#  Issue #
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


 include("global_settings.inc");

 #-----------------------------------------------------------------------------
 # hotfix_check_sp() : This function is to check whether the OS is installed
 # with the given Service Pack or not.
 #
 # Returns Value ;
 #  1 : If the OS is installed with the given Service Pack.
 #  0 : If the OS not installed with the given Service Pack.
 # -1 : If invalid credentials or could not connect to registry.
 #-----------------------------------------------------------------------------

 function hotfix_check_sp(nt, win2k, xp, win2003)
 {
 	local_var winVer, SvPk;

  	winVer = get_kb_item("SMB/WindowsVersion");
  	if(!winVer){
		return -1;
	}

   	if(nt && ("4.0" >< winVer))
  	{
    		SvPk = get_kb_item("SMB/WinNT4/ServicePack");
		if(SvPk){
    			SvPk = int(ereg_replace(string:SvPk, replace:"\1",
			 	        pattern:".*Service Pack ([0-9]).*"));
		}
    		else {
			SvPk = 0;
		}

    		if(SvPk < nt){
			return 1;
		}
		else {
			return 0;
		}
  	}

  	else if(win2k && ("5.0" >< winVer))
  	{
    		SvPk = get_kb_item("SMB/Win2K/ServicePack");
    		if(SvPk){
			SvPk = int(ereg_replace(string:SvPk, replace:"\1",
			 		pattern:".*Service Pack ([0-9]).*"));
		}
    		else {
			SvPk = 0;
		}

		if(SvPk < win2k ){
			return 1;
		}
    		else {
			return 0;
		}
  	}

	else if(xp && ("5.1" >< winVer))
	{
		SvPk = get_kb_item("SMB/WinXP/ServicePack");
		if(SvPk){
			SvPk = int(ereg_replace(string:SvPk, replace:"\1",
					pattern:".*Service Pack ([0-9]).*"));
		}
    		else {
			SvPk = 0;
		}

		if(SvPk < xp){
			return 1;
		}
		else {
			return 0;
		}
  	}

  	else if(win2003 &&  "5.2" >< winVer)
  	{
    		SvPk = get_kb_item("SMB/Win2003/ServicePack");
    		if(SvPk){
			SvPk = int(ereg_replace(string:SvPk, replace:"\1",
				 	pattern:".*Service Pack ([0-9]).*"));
		}
		else {
			SvPk = 0;
		}

    		if(SvPk < win2003){
			return 1;
		}
		else {
			return 0;
		}
  	}
	return -1; 
 }

 #-----------------------------------------------------------------------------
 # hotfix_missing() : This function is to check whether the OS is installed
 # with given hotfix or not.
 #
 # Returns Value :
 #  1 : If hotfix is missing.
 #  0 : If hotfix is present. 
 # -1 : If invalid credentials or could not connect to registry.
 #-----------------------------------------------------------------------------

 function hotfix_missing(name)
 {
 	local_var KB, key;

 	KB = get_kb_list("SMB/Registry/*");
 	if(isnull(KB) || max_index(make_list(keys(KB))) == 0){
 		return -1;
 	}

 	if("KB" >< name){
		name -= "KB";
 	}
 	else if("Q" >< name){
		name -= "Q";
 	}
 	else if("M" >< name){
		name -= "M";
	}

 	foreach key (keys(KB))
 	{
  		if(ereg(pattern:"SMB/Registry/HKLM/SOFTWARE/Microsoft/(Updates/.*|" +
			        "Windows NT/CurrentVersion/HotFix)/(KB|Q|M)" + name,
          		string:key) ){
        		return 0;
		}
 	}
 	return 1;
 }


function hotfix_check_domain_controler()
{
  local_var product_options;
  product_options = get_kb_item("SMB/Registry/HKLM/SYSTEM/CurrentControlSet/Control/ProductOptions");
  if(!product_options){
    return -1;
  }
  if("LanmanNT" >< product_options)
    return 1;
  else return 0;
}

function hotfix_check_nt_server()
{
  local_var product_options;
  product_options = get_kb_item("SMB/Registry/HKLM/SYSTEM/CurrentControlSet/Control/ProductOptions");
  if(!product_options){
    return -1;
  }
  if("WinNT" >< product_options)
    return 0;
  else return 1;
}

function hotfix_check_exchange_installed()
{
  local_var vers;
  vers = get_kb_item("SMB/Registry/HKLM/SOFTWARE/Microsoft/Exchange/Setup/ServicePackBuild");
  if(!vers)
    return NULL;
  else return vers;
}

function hotfix_check_iis_installed()
{
  local_var w3svc;
  w3svc = get_kb_item("SMB/Registry/HKLM/SYSTEM/CurrentControlSet/Services/W3SVC/ImagePath");
  if(!w3svc){
    return -1;
  }
  if("inetinfo" >!< w3svc)
    return 0;
  else return 1;
}
