###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_google_chrome_mult_vuln_nov09.nasl 5767 2009-11-16 16:43:29Z nov $
#
# Google Chrome Multiple Vulnerabilities - Nov09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900890);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3931", "CVE-2009-3932", "CVE-2009-3933", "CVE-2009-3934");
  script_bugtraq_id(36947);
  script_name("Google Chrome Multiple Vulnerabilities - Nov09");
  desc = "
  Overview: This host is installed with Google Chrome and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  - Error in 'browser/download/download_exe.cc', which fails to display a
    warning when a user downloads and opens '.svg', '.mht' or '.xml' files.
    This can be exploited to disclose the content of local files via a
    specially crafted web page.
  - An error in the Gears SQL API implementation can be exploited to put SQL
    metadata into a bad state and cause a memory corruption.
  - An error in WebKit, which can be exploited via a web page that calls the
    JavaScript setInterval method, which triggers an incompatibility between
    the 'WTF::currentTime' and 'base::Time' functions.
  - Error in 'WebFrameLoaderClient::dispatchDidChangeLocationWithinPage' function
    in 'src/webkit/glue/webframeloaderclient_impl.cc' and which can be exploited
    via a page-local link, related to an 'empty redirect chain,' as demonstrated
    by a message in Yahoo! Mail.

  Impact:
  Successful exploitation will let the attacker execute arbitrary JavaScript code
  and disclose the content of local files, memory corruption or CPU consumption
  and which may result in Denial of Service condition.

  Impact Level: System/Application

  Affected Software/OS:
  Google Chrome version prior to 3.0.195.32 on Windows.

  Fix: Upgrade to version 3.0.195.32 or later.
  http://www.google.com/chrome

  References:
  http://secunia.com/advisories/37273/
  http://www.vupen.com/english/advisories/2009/3159
  http://googlechromereleases.blogspot.com/2009/11/stable-channel-update.html
  http://securethoughts.com/2009/11/using-blended-browser-threats-involving-chrome-to-steal-files-on-your-computer/

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

# Get for Chrome Version
chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(!chromeVer){
  exit(0);
}

# Check for Google Chrome version < 3.0.195.32
if(version_is_less(version:chromeVer, test_version:"3.0.195.32")){
  security_hole(0);
}
