###############################################################################
# OpenVAS Vulnerability Test
# $Id: postgreSQL_multiple_security_vulnerabilities.nasl 8287 2010-07-05 10:40:56Z mime $
#
# PostgreSQL Multiple Security Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100273);
 script_bugtraq_id(36314);
 script_cve_id("CVE-2009-3229","CVE-2009-3230","CVE-2009-3231");
 script_version ("1.0-$Revision: 8287 $");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");

 script_name("PostgreSQL Multiple Security Vulnerabilities");

desc = "Overview:
PostgreSQL is prone to multiple security vulnerabilities, including a
denial-of-service issue, a privilege-escalation issue, and an authentication-
bypass issue.

Attackers can exploit these issues to shut down affected servers,
perform certain actions with elevated privileges, and bypass
authentication mechanisms to perform unauthorized actions. Other
attacks may also be possible.


Solution:
Updates are available. Please see the references for more information.


References:
http://www.securityfocus.com/bid/36314
https://bugzilla.redhat.com/show_bug.cgi?id=522085#c1
http://www.postgresql.org/
http://www.postgresql.org/support/security
http://permalink.gmane.org/gmane.comp.security.oss.general/2088


Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if PostgreSQL is prone to multiple security vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Databases");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("postgresql_detect.nasl");
 script_require_ports("Services/postgresql", 5432);
 exit(0);
}

include("misc_func.inc");
include("version_func.inc");

port = get_kb_item("Services/postgresql");
if(!port)port = 5432;
if(!get_tcp_port_state(port))exit(0);

if(!ver = get_kb_list(string("PostgreSQL/Remote/", port, "/Ver")))exit(0);

if(
    version_in_range(version:ver, test_version:"8.4", test_version2:"8.4.0")  ||
    version_in_range(version:ver, test_version:"8.3", test_version2:"8.3.7")  ||
    version_in_range(version:ver, test_version:"8.2", test_version2:"8.2.13") ||
    version_in_range(version:ver, test_version:"8.1", test_version2:"8.1.17") ||
    version_in_range(version:ver, test_version:"8.0", test_version2:"8.0.21") ||
    version_in_range(version:ver, test_version:"7.4", test_version2:"7.4.25") 
  )
{
     security_warning(port:port);
     exit(0);
}

exit(0);
