###############################################################################
# OpenVAS Vulnerability Test
# $Id: phpbb_37882.nasl 7518 2010-05-04 08:39:45Z chandra $
#
# phpBB Forum ID Security Bypass Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100463);
 script_bugtraq_id(37882);
 script_version ("1.0-$Revision: 7518 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("phpBB Forum ID Security Bypass Vulnerability");

desc = "Overview:
phpBB is prone to a security-bypass vulnerability.

Attackers can exploit this vulnerability to bypass certain security
restrictions and gain unauthorized access to the affected application.

Versions prior to phpBB 3.0.5 are vulnerable.

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/37882
http://www.phpbb.com/community/viewtopic.php?f=14&p=9764445
http://www.phpbb.com/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if phpBB version is < 3.0.5");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("phpbb_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/phpBB")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "3.0.5")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
