##################################################################################
#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
#  Ref: r0ut3r
#
# Updated: 04/07/2009
# Antu Sanadi <satnu@secpod.com> 
#  This script is released under the GNU GPL v2
#
# Fixes by Tenable:
#   - added CVE and additional OSVDB xrefs.
#
################################################################################
if(description)
{
  script_id(15433);
  script_cve_id("CVE-2004-2437", "CVE-2004-2438");
  script_bugtraq_id(11296, 12425);
  script_version("$Revision: 8287 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_name("PHP-Fusion members.php SQL injection");
  desc = "
  Description :
  A vulnerability exists in the remote version of PHP-Fusion that may
  allow an attacker to inject arbitrary SQL code and possibly execute
  arbitrary code, due to improper validation of user supplied input in the
  'rowstart' parameter of script 'members.php'.

  Solution:
  Upgrade to new verson.

  Risk factor:Medium";

  script_description(desc);
  script_summary( "Checks the version of the remote PHP-Fusion");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is Copyright (C) 2004 David Maciejak");
  script_family( "Web application abuses");
  script_dependencie("secpod_php_fusion_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port)){
  exit(0);
}

version = get_kb_item("www/" + port + "/php-fusion");
if(!version){
  exit(0);
}

if(version_is_less_equal(version:version,test_version:"4.0.1")){
  security_warning(port);
}
