###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for kernel CESA-2007:1049 centos3 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880316);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.9");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "CESA", value: "2007:1049");
  script_cve_id("CVE-2007-2172", "CVE-2007-3848", "CVE-2006-4538", "CVE-2007-3739", "CVE-2007-4308");
  script_name( "CentOS Update for kernel CESA-2007:1049 centos3 i386");
  desc = "

  Vulnerability Insight:
  The kernel packages contain the Linux kernel, the core of any Linux
  operating system. 
  
  A flaw was found in the handling of process death signals. This allowed a
  local user to send arbitrary signals to the suid-process executed by that
  user. A successful exploitation of this flaw depends on the structure of
  the suid-program and its signal handling. (CVE-2007-3848, Important)
  
  A flaw was found in the IPv4 forwarding base. This allowed a local user to
  cause a denial of service. (CVE-2007-2172, Important) 
  
  A flaw was found where a corrupted executable file could cause cross-region
  memory mappings on Itanium systems. This allowed a local user to cause a
  denial of service. (CVE-2006-4538, Moderate) 
  
  A flaw was found in the stack expansion when using the hugetlb kernel on
  PowerPC systems. This allowed a local user to cause a denial of service.
  (CVE-2007-3739, Moderate) 
  
  A flaw was found in the aacraid SCSI driver. This allowed a local user to
  make ioctl calls to the driver that should be restricted to privileged
  users. (CVE-2007-4308, Moderate) 
  
  As well, these updated packages fix the following bug:
  
  * a bug in the TCP header prediction code may have caused &quot;TCP: Treason
  uncloaked!&quot; messages to be logged. In certain situations this may have lead
  to TCP connections hanging or aborting.
  
  Red Hat Enterprise Linux 3 users are advised to upgrade to these updated
  packages, which contain backported patches to resolve these issues.


  Affected Software/OS:
  kernel on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2007-December/014479.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CentOS3")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.4.21~53.EL", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-BOOT", rpm:"kernel-BOOT~2.4.21~53.EL", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.4.21~53.EL", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-hugemem", rpm:"kernel-hugemem~2.4.21~53.EL", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-hugemem-unsupported", rpm:"kernel-hugemem-unsupported~2.4.21~53.EL", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.4.21~53.EL", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp-unsupported", rpm:"kernel-smp-unsupported~2.4.21~53.EL", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.4.21~53.EL", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-unsupported", rpm:"kernel-unsupported~2.4.21~53.EL", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
