# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0547 (ntp)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63266);
 script_cve_id("CVE-2009-0021", "CVE-2008-5077");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 9 FEDORA-2009-0547 (ntp)";
 script_name(name);

 desc = "The remote host is missing an update to ntp
announced via advisory FEDORA-2009-0547.

Update Information:

This update fixes CVE-2009-0021:    NTP 4.2.4 before 4.2.4p5 and 4.2.5 before
4.2.5p150 does not properly check the return value from the OpenSSL
EVP_VerifyFinal function, which allows remote attackers to bypass validation of
the certificate chain via a malformed SSL/TLS signature for DSA and ECDSA keys,
a similar vulnerability to CVE-2008-5077.

ChangeLog:

* Mon Jan 12 2009 Miroslav Lichvar  4.2.4p6-1.fc9
- update to 4.2.4p6 (CVE-2009-0021)

References:

[ 1 ] Bug #476807 - CVE-2009-0021 ntp incorrectly checks for malformed signatures
https://bugzilla.redhat.com/show_bug.cgi?id=476807

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update ntp' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0547

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-0547 (ntp)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ntp", rpm:"ntp~4.2.4p6~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntp-perl", rpm:"ntp-perl~4.2.4p6~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntpdate", rpm:"ntpdate~4.2.4p6~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntp-debuginfo", rpm:"ntp-debuginfo~4.2.4p6~1.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
