# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 844-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55539);
 script_bugtraq_id(15224);
 script_cve_id("CVE-2005-2963");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 844-1 (mod-auth-shadow)";
 script_name(name);

 desc = "The remote host is missing an update to mod-auth-shadow
announced via advisory DSA 844-1.

A vulnerability in mod_auth_shadow, an Apache module that lets users
perform HTTP authentication against /etc/shadow, has been discovered.
The module runs for all locations that use the 'require group'
directive which would bypass access restrictions controlled by another
authorisation mechanism, such as AuthGroupFile file, if the username
is listed in the password file and in the gshadow file in the proper
group and the supplied password matches against the one in the shadow
file.

This update requires an explicit AuthShadow on statement if website
authentication should be checked against /etc/shadow.

For the old stable distribution (woody) this problem has been fixed in
version 1.3-3.1woody.2.

For the stable distribution (sarge) this problem has been fixed in
version 1.4-1sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 1.4-2.

We recommend that you upgrade your libapache-mod-auth-shadow package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20844-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 844-1 (mod-auth-shadow)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libapache-mod-auth-shadow", ver:"1.3-3.1woody.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-auth-shadow", ver:"1.4-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
