# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 717-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53544);
 script_cve_id("CVE-2003-0826", "CVE-2005-0814");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 717-1 (lsh-utils)";
 script_name(name);

 desc = "The remote host is missing an update to lsh-utils
announced via advisory DSA 717-1.

Several security relevant problems have been discovered in lsh, the
alternative secure shell v2 (SSH2) protocol server.  The Common
Vulnerabilities and Exposures project identifies the following
vulnerabilities:

CVE-2003-0826

Bennett Todd discovered a heap buffer overflow in lshd which could
lead to the execution of arbitrary code.

CVE-2005-0814

Niels Mller discovered a denial of service condition in lshd.

For the stable distribution (woody) these problems have been fixed in
version 1.2.5-2woody3.

For the unstable distribution (sid) these problems have been fixed in
version 2.0.1-2.

We recommend that you upgrade your lsh-server package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20717-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 717-1 (lsh-utils)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"lsh-utils-doc", ver:"1.2.5-2woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lsh-client", ver:"1.2.5-2woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lsh-server", ver:"1.2.5-2woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lsh-utils", ver:"1.2.5-2woody3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
