# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1515-1 (libnet-dns-perl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60567);
 script_cve_id("CVE-2007-3377", "CVE-2007-3409", "CVE-2007-6341");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1515-1 (libnet-dns-perl)";
 script_name(name);

 desc = "The remote host is missing an update to libnet-dns-perl
announced via advisory DSA 1515-1.

Several remote vulnerabilities have been discovered in libnet-dns-perl.
The Common Vulnerabilities and Exposures project identifies the
following problems:

It was discovered that libnet-dns-perl generates very weak transaction
IDs when sending queries (CVE-2007-3377).  This update switches
transaction ID generation to the Perl random generator, making
prediction attacks more difficult.

Compression loops in domain names resulted in an infinite loop in the
domain name expander written in Perl (CVE-2007-3409).  The Debian
package uses an expander written in C by default, but this vulnerability
has been addressed nevertheless.

Decoding malformed A records could lead to a crash (via an uncaught
Perl exception) of certain applications using libnet-dns-perl
(CVE-2007-6341).

For the stable distribution (etch), these problems have been fixed in
version 0.59-1etch1.

For the old stable distribution (sarge), these problems have been fixed in
version 0.48-1sarge1.

We recommend that you upgrade your libnet-dns-perl package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201515-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1515-1 (libnet-dns-perl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libnet-dns-perl", ver:"0.48-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnet-dns-perl", ver:"0.59-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
