###############################################################################
# OpenVAS Vulnerability Test
# $Id: AnswerBook2_12746.nasl 7190 2010-03-31 14:02:04Z chandra $
#
# Sun Solaris AnswerBook2 Multiple Cross-Site Scripting Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100388);
 script_bugtraq_id(12746);
 script_cve_id("CVE-2005-0548","CVE-2005-0549");
 script_version ("1.0-$Revision: 7190 $");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Sun Solaris AnswerBook2 Multiple Cross-Site Scripting Vulnerabilities");

desc = "Overview:
Sun Solaris AnswerBook2 is reported prone to multiple cross-site
scripting vulnerabilities. These issues arise due to insufficient
sanitization of user-supplied data facilitating execution of arbitrary
HTML and script code in a user's browser.

The following specific issues were identified:

It is reported that the Search function of the application is affected
by a cross-site scripting vulnerability.

The AnswerBook2 admin interface is prone to cross-site scripting
attacks as well.

These issues can lead to theft of cookie based credentials and
other attacks.

AnswerBook2 1.4.4 and prior versions are affected by these issues.

Solution:
Sun has released a advisory to address these issues. The vendor
recommends disabling the application and referring to Sun
documentation at the Sun Product Documentation Web site at
http://docs.sun.com or viewing the documentation on the Solaris
Documentation CD.

Please see the referenced advisory for more information.

References:
http://www.securityfocus.com/bid/12746
http://wwws.sun.com/software//ab2/
http://sunsolve.sun.com/search/document.do?assetkey=1-26-57737-1&searchclause=%22category:security%22%20%22availability,%20security%22
http://www.securityfocus.com/archive/1/394429
http://sunsolve.sun.com/search/document.do?assetkey=1-66-200305-1

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if AnswerBook2 is prone to multiple xss vulnerabilities");
 script_category(ACT_ATTACK);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 8888);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
   
port = get_http_port(default:8888);
if(!get_port_state(port))exit(0);

banner = get_http_banner(port: port);
if("dwhttpd" >!< banner)exit(0);

url = string("/ab2/Help_C/@Ab2HelpSearch?scope=HELP&DwebQuery=%3Cscript%3Ealert(%27OpenVAS-XSS-Test%27)%3C/script%3E&Search=+Search+"); 
req = http_get(item:url, port:port);
buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);  
if( buf == NULL )continue;

if(egrep(pattern: "<script>alert\('OpenVAS-XSS-Test'\)</script>", string: buf, icase: TRUE)) {
     
  security_warning(port:port);
  exit(0);

}

exit(0);

