// $Id: MSXMultiIODevice.hh 8352 2008-11-12 18:39:08Z m9710797 $

#ifndef MSXMULTIIODEVICE_HH
#define MSXMULTIIODEVICE_HH

#include "MSXMultiDevice.hh"
#include <vector>

namespace openmsx {

class MSXMultiIODevice : public MSXMultiDevice
{
public:
	typedef std::vector<MSXDevice*> Devices;

	explicit MSXMultiIODevice(MSXMotherBoard& motherboard);
	virtual ~MSXMultiIODevice();

	void addDevice(MSXDevice* device);
	void removeDevice(MSXDevice* device);
	Devices& getDevices();

	// MSXDevice
	virtual std::string getName() const;
	virtual byte readIO(word port, EmuTime::param time);
	virtual byte peekIO(word port, EmuTime::param time) const;
	virtual void writeIO(word port, byte value, EmuTime::param time);

private:
	Devices devices;
};

} // namespace openmsx

#endif
