// $Id: VideoLayer.hh,v 1.7 2005/01/04 10:34:08 m9710797 Exp $

#ifndef __VIDEOLAYER_HH__
#define __VIDEOLAYER_HH__

#include "Layer.hh"
#include "SettingListener.hh"
#include "VideoSourceSetting.hh"

namespace openmsx {

template <class T> class EnumSetting;
class BooleanSetting;

class VideoLayer: public Layer, protected SettingListener
{
public:
	virtual ~VideoLayer();

protected:
	VideoLayer(VideoSource videoSource);

	// SettingListener interface:
	virtual void update(const Setting* setting);

private:
	/** Calculates the current Z coordinate of this layer. */
	ZIndex calcZ();
	/** Calculates the current coverage of this layer. */
	Coverage getCoverage();

	/** Video source that displays on this layer. */
	VideoSource videoSource;
	/** Reference to "videosource" setting. */
	VideoSourceSetting& videoSourceSetting;
	/** Activate the videosource */
	VideoSourceActivator videoSourceActivator;
	/** Reference to "power" setting. */
	BooleanSetting& powerSetting;
};

} // namespace openmsx

#endif //__VIDEOLAYER_HH__
