// $Id: DACSound8U.cc,v 1.7 2004/12/15 09:09:50 m9710797 Exp $

#include "DACSound8U.hh"

using std::string;

namespace openmsx {

DACSound8U::DACSound8U(const string& name, const string& desc,
                       const XMLElement& config, const EmuTime& time)
	: DACSound16S(name, desc, config, time)
{
}

DACSound8U::~DACSound8U()
{
}

void DACSound8U::writeDAC(byte value, const EmuTime& time)
{
	DACSound16S::writeDAC(((short)value - 0x80) << 8, time);
}

} // namespace openmsx
