// $Id: IDEDeviceFactory.cc,v 1.15 2005/01/15 12:55:44 m9710797 Exp $

#include "IDEDeviceFactory.hh"
#include "IDEHD.hh"
#include "XMLElement.hh"
#include "MSXException.hh"

using std::string;

namespace openmsx {

IDEDevice* IDEDeviceFactory::create(const XMLElement& config,
                                    const EmuTime& time)
{
	const string& type = config.getChildData("type");
	if (type == "IDEHD") {
		return new IDEHD(config, time);
	}
	
	throw FatalError("Unknown IDE device: " + type);
}

} // namespace openmsx
