// $Id: MSXE6Timer.hh,v 1.24 2004/10/19 19:47:43 m9710797 Exp $

/*
 * This class implements a simple timer, used in a TurboR.
 * This is a 16-bit (up) counter running at 255681Hz (3.58MHz / 14).
 * The least significant byte can be read from port 0xE6.
 *     most                                         0xE7.
 * Writing a random value to port 0xE6 resets the counter.
 * Writing to port 0xE7 has no effect.
 */

#ifndef __MSXE6TIMER_HH__
#define __MSXE6TIMER_HH__

#include "MSXDevice.hh"
#include "EmuTime.hh"

namespace openmsx {

class MSXE6Timer : public MSXDevice
{
public:
	MSXE6Timer(const XMLElement& config, const EmuTime& time);
	virtual ~MSXE6Timer();
	
	virtual void reset(const EmuTime& time);
	
	virtual byte readIO(byte port, const EmuTime& time);
	virtual void writeIO(byte port, byte value, const EmuTime& time);
	virtual byte peekIO(byte port, const EmuTime& time) const;

private:
	Clock<255681> reference; // 1/14 * 3.58MHz
};

} // namespace openmsx

#endif //__MSXE6TIMER_HH__
