/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.36
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */


using System;
using System.Runtime.InteropServices;

public class vectorData : IDisposable, System.Collections.IEnumerable {
  private HandleRef swigCPtr;
  protected bool swigCMemOwn;

  internal vectorData(IntPtr cPtr, bool cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = new HandleRef(this, cPtr);
  }

  internal static HandleRef getCPtr(vectorData obj) {
    return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
  }

  ~vectorData() {
    Dispose();
  }

  public virtual void Dispose() {
    lock(this) {
      if(swigCPtr.Handle != IntPtr.Zero && swigCMemOwn) {
        swigCMemOwn = false;
        openbabelPINVOKE.delete_vectorData(swigCPtr);
      }
      swigCPtr = new HandleRef(null, IntPtr.Zero);
      GC.SuppressFinalize(this);
    }
  }

  public vectorData(System.Collections.ICollection c) : this() {
    if (c == null)
      throw new ArgumentNullException("c");
    foreach (OBGenericData element in c) {
      this.Add(element);
    }
  }

  public bool IsFixedSize {
    get {
      return false;
    }
  }

  public bool IsReadOnly {
    get {
      return false;
    }
  }

  public OBGenericData this[int index]  {
    get {
      return getitem(index);
    }
    set {
      setitem(index, value);
    }
  }

  public int Capacity {
    get {
      return (int)capacity();
    }
    set {
      if (value < size())
        throw new ArgumentOutOfRangeException("Capacity");
      reserve((uint)value);
    }
  }

  public int Count {
    get {
      return (int)size();
    }
  }

  public bool IsSynchronized {
    get {
      return false;
    }
  }

  public void CopyTo(System.Array array) {
    CopyTo(0, array, 0, this.Count);
  }

  public void CopyTo(System.Array array, int arrayIndex) {
    CopyTo(0, array, arrayIndex, this.Count);
  }

  public void CopyTo(int index, System.Array array, int arrayIndex, int count) {
    if (array == null)
      throw new ArgumentNullException("array");
    if (index < 0)
      throw new ArgumentOutOfRangeException("index", "Value is less than zero");
    if (arrayIndex < 0)
      throw new ArgumentOutOfRangeException("arrayIndex", "Value is less than zero");
    if (count < 0)
      throw new ArgumentOutOfRangeException("count", "Value is less than zero");
    if (array.Rank > 1)
      throw new ArgumentException("Multi dimensional array.");
    if (index+count > this.Count || arrayIndex+count > array.Length)
      throw new ArgumentException("Number of elements to copy is too large.");
    for (int i=0; i<count; i++)
      array.SetValue(getitemcopy(index+i), arrayIndex+i);
  }

  // Type-safe version of IEnumerable.GetEnumerator
  System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() {
    return new vectorDataEnumerator(this);
  }

  public vectorDataEnumerator GetEnumerator() {
    return new vectorDataEnumerator(this);
  }

  // Type-safe enumerator
  /// Note that the IEnumerator documentation requires an InvalidOperationException to be thrown
  /// whenever the collection is modified. This has been done for changes in the size of the
  /// collection but not when one of the elements of the collection is modified as it is a bit
  /// tricky to detect unmanaged code that modifies the collection under our feet.
  public sealed class vectorDataEnumerator : System.Collections.IEnumerator {
    private vectorData collectionRef;
    private int currentIndex;
    private object currentObject;
    private int currentSize;

    public vectorDataEnumerator(vectorData collection) {
      collectionRef = collection;
      currentIndex = -1;
      currentObject = null;
      currentSize = collectionRef.Count;
    }

    // Type-safe iterator Current
    public OBGenericData Current {
      get {
        if (currentIndex == -1)
          throw new InvalidOperationException("Enumeration not started.");
        if (currentIndex > currentSize - 1)
          throw new InvalidOperationException("Enumeration finished.");
        if (currentObject == null)
          throw new InvalidOperationException("Collection modified.");
        return (OBGenericData)currentObject;
      }
    }

    // Type-unsafe IEnumerator.Current
    object System.Collections.IEnumerator.Current {
      get {
        return Current;
      }
    }

    public bool MoveNext() {
      int size = collectionRef.Count;
      bool moveOkay = (currentIndex+1 < size) && (size == currentSize);
      if (moveOkay) {
        currentIndex++;
        currentObject = collectionRef[currentIndex];
      } else {
        currentObject = null;
      }
      return moveOkay;
    }

    public void Reset() {
      currentIndex = -1;
      currentObject = null;
      if (collectionRef.Count != currentSize) {
        throw new InvalidOperationException("Collection modified.");
      }
    }
  }

  public void Clear() {
    openbabelPINVOKE.vectorData_Clear(swigCPtr);
  }

  public void Add(OBGenericData x) {
    openbabelPINVOKE.vectorData_Add(swigCPtr, OBGenericData.getCPtr(x));
  }

  private uint size() {
    uint ret = openbabelPINVOKE.vectorData_size(swigCPtr);
    return ret;
  }

  private uint capacity() {
    uint ret = openbabelPINVOKE.vectorData_capacity(swigCPtr);
    return ret;
  }

  private void reserve(uint n) {
    openbabelPINVOKE.vectorData_reserve(swigCPtr, n);
  }

  public vectorData() : this(openbabelPINVOKE.new_vectorData__SWIG_0(), true) {
  }

  public vectorData(int capacity) : this(openbabelPINVOKE.new_vectorData__SWIG_1(capacity), true) {
    if (openbabelPINVOKE.SWIGPendingException.Pending) throw openbabelPINVOKE.SWIGPendingException.Retrieve();
  }

  private OBGenericData getitemcopy(int index) {
    IntPtr cPtr = openbabelPINVOKE.vectorData_getitemcopy(swigCPtr, index);
    OBGenericData ret = (cPtr == IntPtr.Zero) ? null : new OBGenericData(cPtr, false);
    if (openbabelPINVOKE.SWIGPendingException.Pending) throw openbabelPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  private OBGenericData getitem(int index) {
    IntPtr cPtr = openbabelPINVOKE.vectorData_getitem(swigCPtr, index);
    OBGenericData ret = (cPtr == IntPtr.Zero) ? null : new OBGenericData(cPtr, false);
    if (openbabelPINVOKE.SWIGPendingException.Pending) throw openbabelPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  private void setitem(int index, OBGenericData val) {
    openbabelPINVOKE.vectorData_setitem(swigCPtr, index, OBGenericData.getCPtr(val));
    if (openbabelPINVOKE.SWIGPendingException.Pending) throw openbabelPINVOKE.SWIGPendingException.Retrieve();
  }

  public void AddRange(vectorData values) {
    openbabelPINVOKE.vectorData_AddRange(swigCPtr, vectorData.getCPtr(values));
    if (openbabelPINVOKE.SWIGPendingException.Pending) throw openbabelPINVOKE.SWIGPendingException.Retrieve();
  }

  public vectorData GetRange(int index, int count) {
    IntPtr cPtr = openbabelPINVOKE.vectorData_GetRange(swigCPtr, index, count);
    vectorData ret = (cPtr == IntPtr.Zero) ? null : new vectorData(cPtr, true);
    if (openbabelPINVOKE.SWIGPendingException.Pending) throw openbabelPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public void Insert(int index, OBGenericData x) {
    openbabelPINVOKE.vectorData_Insert(swigCPtr, index, OBGenericData.getCPtr(x));
    if (openbabelPINVOKE.SWIGPendingException.Pending) throw openbabelPINVOKE.SWIGPendingException.Retrieve();
  }

  public void InsertRange(int index, vectorData values) {
    openbabelPINVOKE.vectorData_InsertRange(swigCPtr, index, vectorData.getCPtr(values));
    if (openbabelPINVOKE.SWIGPendingException.Pending) throw openbabelPINVOKE.SWIGPendingException.Retrieve();
  }

  public void RemoveAt(int index) {
    openbabelPINVOKE.vectorData_RemoveAt(swigCPtr, index);
    if (openbabelPINVOKE.SWIGPendingException.Pending) throw openbabelPINVOKE.SWIGPendingException.Retrieve();
  }

  public void RemoveRange(int index, int count) {
    openbabelPINVOKE.vectorData_RemoveRange(swigCPtr, index, count);
    if (openbabelPINVOKE.SWIGPendingException.Pending) throw openbabelPINVOKE.SWIGPendingException.Retrieve();
  }

  public static vectorData Repeat(OBGenericData value, int count) {
    IntPtr cPtr = openbabelPINVOKE.vectorData_Repeat(OBGenericData.getCPtr(value), count);
    vectorData ret = (cPtr == IntPtr.Zero) ? null : new vectorData(cPtr, true);
    if (openbabelPINVOKE.SWIGPendingException.Pending) throw openbabelPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public void Reverse() {
    openbabelPINVOKE.vectorData_Reverse__SWIG_0(swigCPtr);
  }

  public void Reverse(int index, int count) {
    openbabelPINVOKE.vectorData_Reverse__SWIG_1(swigCPtr, index, count);
    if (openbabelPINVOKE.SWIGPendingException.Pending) throw openbabelPINVOKE.SWIGPendingException.Retrieve();
  }

  public void SetRange(int index, vectorData values) {
    openbabelPINVOKE.vectorData_SetRange(swigCPtr, index, vectorData.getCPtr(values));
    if (openbabelPINVOKE.SWIGPendingException.Pending) throw openbabelPINVOKE.SWIGPendingException.Retrieve();
  }

}
