/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "RequestPluginsEvent.h"
#include "Om.h"
#include "OSCSender.h"

namespace Om {


RequestPluginsEvent::RequestPluginsEvent(Request* request, const string& url)
: SlowEvent(request),
  m_url(url),
  m_addr(lo_address_new_from_url(m_url.c_str()))
{
}


RequestPluginsEvent::~RequestPluginsEvent()
{
	lo_address_free(m_addr);
}


// I guess this doesn't need to be a slow event?
void
RequestPluginsEvent::prepare()
{
	SlowEvent::prepare();
}


void
RequestPluginsEvent::execute(uint sample_offset)
{
	SlowEvent::execute(sample_offset);
}


void
RequestPluginsEvent::post_process()
{
	if (m_addr != NULL) {
		m_request->respond_ok();
		om->osc_sender()->send_plugins(m_addr);
	} else {
		m_request->respond_error("Invalid URL");
	}
}


} // namespace Om

