/* user.c - supporting elements of user handling functions for upsd

   Copyright (C) 2001  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

typedef struct {
	char	*aclname;
	void    *next;
} acllist;

typedef struct {
        int     cmd;
        void    *next;
} instcmdlist;

typedef struct {
	char	*action;
	void	*next;
} actionlist;

typedef struct {
	char	*username;
	acllist *firstacl;
	char    *password;
	instcmdlist *firstcmd;
	actionlist  *firstaction;
	void    *next;
} ulist_t;

	/* redefine this here, since the main file has an initializer */

typedef struct { 
        char    *name;
        int     cmd;
        char    *desc;
} instcmds_t;

/* this deals with 'all' without polluting the table */
#define CMD_ALL	0x2FFF
