/* upsct - simple "client" to test communications (TCP mode)

   Copyright (C) 1999  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include "common.h"

#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include "upsfetch.h"

int main (int argc, char **argv)
{
	char	vars[LARGEBUF], value[128], *v, *upsname, *ptr, *host;
	int	fd;

	if (argc < 2) {
		printf ("usage: %s <host>\n", argv[0]);
		exit (1);
	}

	/* handle upsname@hostname syntax and split up parts */
	ptr = strstr (argv[1], "@");
	if (ptr != NULL) {
		ptr[0] = 0;
		upsname = argv[1];
		host = ptr + 1;
	}
	else {
		upsname = NULL;
		host = argv[1];
	}

	fd = upsconnect (host);
	if (fd < 0) {
		printf ("Unable to connect to %s - %s\n", host,
		        upsstrerror(upserror));
		exit (1);
	}

	if (getupsvarlistfd (fd, upsname, vars, sizeof(vars)) < 0) {
		printf ("Unable to get variable list - %s\n", 
		        upsstrerror(upserror));
		exit (1);
	}

	printf ("host: %s\n", host);

	if (strlen(vars) == 0) {
		printf ("No variables available!  Check your configuration (ups.conf and upsd.conf)\n");
		exit (1);
	}

	v = vars;
	while (v != NULL) {
		ptr = strchr (v, ' ');
		if (ptr)
			*ptr++ = '\0';

		printf ("%s: ", v);
		if (getupsvarfd(fd, upsname, v, value, sizeof(value)) < 0)
			printf ("Error: %s\n", upsstrerror(upserror));
		else
			printf ("%s\n", value);

		v = ptr;
	}		

	return (0);
}
