#ifndef FD_nj_plot_h_
#define FD_nj_plot_h_
/* Header file generated with fdesign. */

/**** Callback routines ****/

extern void open_callback(Nlm_IteM );
extern void font_callback(Nlm_ChoicE);
extern void paper_callback(Nlm_ChoicE);
extern void taille_callback(Nlm_ChoicE);
extern void style_callback(Nlm_ChoicE);
extern void save_plot_callback(Nlm_IteM);
extern void save_tree_callback(Nlm_IteM);
extern void toggle_branch_callback(Nlm_ButtoN);
extern void toggle_bootstrap_callback(Nlm_ButtoN);
extern void operation_callback(Nlm_GrouP);
extern void subtree_callback(void);
extern void swap_callback(void);
extern void new_outgroup_callback(void);
extern void show_tree_callback(void);
extern void exit_callback(Nlm_IteM);
extern void tree_draw_proc(Nlm_PaneL);
extern void tree_click_proc(Nlm_PaneL, Nlm_PoinT);
extern void process_args(int *argc, char *argv[]);
extern int myrint(double val);

/**** Forms and Objects ****/

typedef struct {
	Nlm_WindoW nj_plot;
	Nlm_IteM open_button;
	Nlm_PrompT click_message;
	Nlm_MenU tree_font_menu;
	Nlm_MenU paper_menu;
	Nlm_IteM save_plot_button;
	Nlm_IteM save_tree_button;
	Nlm_IteM AgainItem;
	Nlm_ChoicE choix_font, choix_taille;
	Nlm_IteM bold_item, italic_item;
	Nlm_ButtoN branch_length_button;
	Nlm_ButtoN bootstrap_button;
	Nlm_GrouP choix_group;
	Nlm_ButtoN reroot_button;
	Nlm_ButtoN subtree_up_button;
	Nlm_IteM exit_button;
	Nlm_PaneL tree_plot;
	char *tree_name;
} FD_nj_plot;

typedef enum { times = 1, helvetica, courier} font_name;
typedef enum { font_tiny = 1, font_small,
	font_normal, font_medium, font_large, font_bold, font_italic } font_size;
typedef enum { A4 = 1, LETTER } 
	paper_item;

extern FD_nj_plot *create_win_nj_plot(void);
extern int direct_ps_plot(void);
extern int ps_plot_only, plot_br_l;
extern int font_size_rank;

#endif /* FD_nj_plot_h_ */
