#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <limits.h>
#include <libnjb.h>
#include <unistd.h>

extern int njb_error;

int main (int argc, char **argv)
{
	njb_t njbs[NJB_MAX_DEVICES], *njb;
	int n, debug;
	playlist_t *playlist;
	extern char *optarg;
	int opt;

	debug= 0;
	while ( (opt= getopt(argc, argv, "D:")) != -1 ) {
		switch (opt) {
		case 'D':
			debug= atoi(optarg);
			break;
		default:
			fprintf(stderr, "usage: njbplaylists [ -D debuglvl ]\n");
			return 1;
		}
	}

	if ( debug ) NJB_Set_Debug(debug);

	if ( NJB_Discover(njbs, 0, &n) == -1 ) njb_error_dump(stderr);
	if ( n == 0 ) {
		fprintf(stderr, "XXX no NJB devices found\n");
		return 0;
	} 

	njb= njbs;

	if ( NJB_Open(njb) == -1 ) {
		njb_error_dump(stderr);
		return 1;
	}

	if ( NJB_Capture(njb) == -1 ) {
		njb_error_dump(stderr);
		return 1;
	}

	printf("<?xml version='1.0'?>\n");
	printf("<plist>\n");
	printf(" <dict>\n");
	NJB_Reset_Get_Playlist(njb);
	while ( (playlist= NJB_Get_Playlist(njb)) ) {
		//playlist_dump(playlist, stdout);
		playlist_track_t *track;
		printf("  <key>%u</key>\n",playlist->plid);
		printf("  <dict>\n");
		printf("   <key>Name</key>\n");
		printf("   <string>%s</string>\n",playlist->name);
		printf("   <key>ID</key>\n");
		printf("   <integer>%u</integer>\n",playlist->plid);
		printf("   <key>State</key>\n");
		printf("   <integer>%u</integer>\n",playlist->_state);
		printf("   <key>Tracks</key>\n");
		printf("   <array>\n");
		playlist_reset_gettrack(playlist);
		while ((track = playlist_gettrack(playlist))) {
			printf("    <integer>%u</integer>\n",track->trackid);
		}
		printf("    </array>\n");
		printf("  </dict>\n");
	}
	if ( njb_error != EO_EOM ) njb_error_dump(stderr);
	printf(" </dict>\n");
	printf("</plist>\n");

	NJB_Release(njb);

	NJB_Close(njb);
	return 0;
}

