/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_ip_h
#define __nd_ip_h

#include <sys/types.h>
#include <nd_packet.h>

/* These set the various IP fields to the given
   values, for all selected packets. PROT specifies
   whether we're talking about a "real" IP header
   or the one contained in an ICMP error message.
*/
void    ip_v(u_int value, ND_Protocol prot);
void    ip_hl(u_int value, ND_Protocol prot);
void    ip_tos(u_int8_t value, ND_Protocol prot);
void    ip_len(u_short value, ND_Protocol prot);
void    ip_id(u_short value, ND_Protocol prot);
void    ip_rf(int onoff, ND_Protocol prot);
void    ip_df(int onoff, ND_Protocol prot);
void    ip_mf(int onoff, ND_Protocol prot);
void    ip_off(u_short value, ND_Protocol prot);
void    ip_ttl(u_int8_t value, ND_Protocol prot);
void    ip_p(u_int8_t value, ND_Protocol prot);
void    ip_sum(u_short value, ND_Protocol prot);
void    ip_src(struct in_addr ip_addr, ND_Protocol prot);
void    ip_dst(struct in_addr ip_addr, ND_Protocol prot);

void    ip_recalc_checksum(ND_Packet *p, ND_Protocol prot);

#endif
