/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#include <nd_misc.h>
#include <nd_packet.h>


/* The Checksum Fix plugin. It fixes the checksums of
   any IP, TCP, UDP and ICMP headers in all packets
   the plugin is applied to. Checksums in any headers
   contained in ICMP error replies stay untouched.
*/


char *
name(void)
{
  return ("Checksum Fix Plugin");
}


char *
description(void)
{
  return ("The Checksum Fix plugin. It corrects the checksums of\n"
	  "any IP, TCP, UDP and ICMP headers in all packets\n"
	  "the plugin is applied to. Checksums in any headers\n"
	  "contained in ICMP error replies stay untouched.\n");
}


char *
author(void)
{
  return ("Author: Christian Kreibich, <cK@whoop.org>");
}


int
op(ND_Packet *p)
{
  switch (p->net_prot)
    {
    case ND_PROT_IP:
      {
	struct ip* iphdr = nd_packet_ip(p);
	iphdr->ip_sum = nd_misc_ip_checksum(p);
      }
      break;
    default:
    }
  
  switch (p->transp_prot)
    {
    case ND_PROT_ICMP:
      {
	struct icmp* icmphdr = nd_packet_icmp(p);
	icmphdr->icmp_cksum = nd_misc_icmp_checksum(p);
      }
      break;
    case ND_PROT_TCP:
      {
	struct tcphdr* tcphdr = nd_packet_tcp(p);
	tcphdr->th_sum = nd_misc_tcp_checksum(p);
      }
      break;
    case ND_PROT_UDP:
      {
	struct udphdr* udphdr = nd_packet_udp(p);
	udphdr->uh_sum = nd_misc_udp_checksum(p);
      }
      break;
    default:
      return (FALSE);
    }
  
  return (TRUE);
}
