/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2009 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.javacard.project.ui;

import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

import javax.swing.*;
import java.awt.*;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Map;
import java.util.SortedMap;

/**
 *
 * @author Tim Boudreau
 */
public class UnsupportedEncodingDialog extends javax.swing.JPanel implements Runnable {

    private final DefaultComboBoxModel mdl = new DefaultComboBoxModel();
    private DialogDescriptor descriptor;

    /** Creates new form UnsupportedEncodingDialog */
    public UnsupportedEncodingDialog() {
        initComponents();
        Cursor cursor = Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR);
        setCursor(cursor);
        instructions.setCursor(cursor);
        charsetComboBox.setCursor(cursor);
    }

    void setDialogDescriptor(DialogDescriptor d) {
        this.descriptor = d;
    }

    public static Charset showDialog(String projectName, String requestedCharset) {
        UnsupportedEncodingDialog pnl = new UnsupportedEncodingDialog();
        String s = pnl.instructions.getText();
        MessageFormat.format(s, new Object[] { requestedCharset });
        String title = NbBundle.getMessage(UnsupportedEncodingDialog.class,
                "UNSUPPORTED_ENCODING", requestedCharset, projectName); //NO18N
        String close = NbBundle.getMessage(UnsupportedEncodingDialog.class,
                "CLOSE"); //NOI18N
        DialogDescriptor des = new DialogDescriptor (pnl,
                title, true, new Object[] { close },
                close, DialogDescriptor.DEFAULT_ALIGN,
                HelpCtx.DEFAULT_HELP, null); //NOI18N
        pnl.setDialogDescriptor(des);
        DialogDisplayer.getDefault().notify(des);
        return pnl.getSelectedCharset();
    }

    private Charset getSelectedCharset() {
        Object o = charsetComboBox.getSelectedItem();
        if (o instanceof Entry) {
            return ((Entry) o).charset;
        } else {
            //should never happen
            return Charset.forName("UTF-8");
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        instructions = new javax.swing.JLabel();
        charsetComboBox = new javax.swing.JComboBox();

        instructions.setLabelFor(charsetComboBox);
        instructions.setText(org.openide.util.NbBundle.getMessage(UnsupportedEncodingDialog.class, "UnsupportedEncodingDialog.instructions.text", new Object[] {})); // NOI18N

        charsetComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "[Loading all character sets]" }));
        charsetComboBox.setEnabled(false);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, charsetComboBox, 0, 359, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, instructions, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 359, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(instructions)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(charsetComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    @Override
    public void addNotify() {
        super.addNotify();
        RequestProcessor.getDefault().post(this);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox charsetComboBox;
    private javax.swing.JLabel instructions;
    // End of variables declaration//GEN-END:variables

    public void run() {
        if (!EventQueue.isDispatchThread()) {
            try {
                Entry utf8 = null;
                if (!EventQueue.isDispatchThread()) {
                    SortedMap<String, Charset> m = Charset.availableCharsets();
                    for (Map.Entry<String, Charset> e : m.entrySet()) {
                        Entry entry = new Entry(e.getKey(), e.getValue());
                        if ("UTF-8".equals(e.getKey().toUpperCase())) {
                            utf8 = entry;
                        }
                        mdl.addElement(entry);
                    }
                }
                if (utf8 != null) {
                    mdl.setSelectedItem(utf8);
                }
            } finally {
                EventQueue.invokeLater(this);
            }
        } else {
            charsetComboBox.setModel(mdl);
            charsetComboBox.setEnabled(true);
            Cursor cursor = Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR);
            setCursor(cursor);
            instructions.setCursor(cursor);
            charsetComboBox.setCursor(cursor);
            if (descriptor != null) {
                descriptor.setValid(false);
            }
        }
    }

    private static final class Entry {

        String nm;
        Charset charset;

        public Entry(String nm, Charset charset) {
            this.nm = nm;
            this.charset = charset;
        }

        @Override
        public String toString() {
            return charset.displayName();
        }
    }
}
