/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2010 Sun Microsystems, Inc.
 */

/*
 * SavePanel.java
 *
 * Created on Mar 23, 2010, 4:01:47 PM
 */

package org.netbeans.modules.bugtracking.util;

import java.awt.Color;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/**
 *
 * @author tomas
 */
public class SaveQueryPanel extends javax.swing.JPanel implements DocumentListener {
    private static JButton ok;
    private DialogDescriptor descriptor;
    private QueryNameValidator validator;
    private static final Color ERROR_COLOR = new Color(153,0,0);

    /** Creates new form SavePanel */
    private SaveQueryPanel() {
        initComponents();
        queryNameTextField.getDocument().addDocumentListener(this);

        saveErrorLabel.setForeground(ERROR_COLOR);
        Image img = ImageUtilities.loadImage("org/netbeans/modules/bugtracking/ui/resources/error.gif"); //NOI18N
        saveErrorLabel.setIcon( new ImageIcon(img) );
        saveErrorLabel.setVisible(false);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel3 = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(SaveQueryPanel.class, "SaveQueryPanel.jLabel3.text")); // NOI18N

        saveErrorLabel.setText(org.openide.util.NbBundle.getMessage(SaveQueryPanel.class, "SaveQueryPanel.saveErrorLabel.text_1")); // NOI18N

        queryNameTextField.setColumns(18);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(saveErrorLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 436, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(jLabel3)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(queryNameTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel3)
                    .add(queryNameTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(saveErrorLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 17, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(34, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel3;
    final javax.swing.JTextField queryNameTextField = new javax.swing.JTextField();
    final javax.swing.JLabel saveErrorLabel = new javax.swing.JLabel();
    // End of variables declaration//GEN-END:variables

    @Override
    public void insertUpdate(DocumentEvent e) {
        validatePanel();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        validatePanel();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        validatePanel();
    }

    private void validatePanel() {
        String name = queryNameTextField.getText();
        String errText = validator.isValid(name);
        boolean valid = !name.equals("") && errText == null;
        ok.setEnabled(valid);
        if(errText != null) {
            saveErrorLabel.setText(errText);
            saveErrorLabel.setVisible(true);
        } else {
            saveErrorLabel.setText("");
            saveErrorLabel.setVisible(false);
        }
    }

    public static String show(QueryNameValidator validator, HelpCtx helpCtx) {
        SaveQueryPanel panel = new SaveQueryPanel();
        panel.validator = validator;
        if (panel.descriptor == null) {
            ok = new JButton(NbBundle.getMessage(SaveQueryPanel.class, "LBL_Save")); // NOI18N
            ok.getAccessibleContext().setAccessibleDescription(ok.getText());
            JButton cancel = new JButton(NbBundle.getMessage(SaveQueryPanel.class, "LBL_Cancel")); // NOI18N
            cancel.getAccessibleContext().setAccessibleDescription(cancel.getText());
            panel.descriptor = new DialogDescriptor(
                    panel,
                    NbBundle.getMessage(SaveQueryPanel.class, "LBL_SaveQuery"), // NOI18N
                    true,
                    new Object[]{ok, cancel},
                    ok,
                    DialogDescriptor.DEFAULT_ALIGN,
                    helpCtx,
                    null);
        }
        panel.validatePanel();
        if(DialogDisplayer.getDefault().notify(panel.descriptor) == ok) {
            return panel.queryNameTextField.getText();
        } else {
            return null;
        }
    }

    public static abstract class QueryNameValidator {
        public abstract String isValid(String name);
    }
}
