/* Nessus
 * Copyright (C) 1998 - 2001 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * In addition, as a special exception, Renaud Deraison
 * gives permission to link the code of this program with any
 * version of the OpenSSL library which is distributed under a
 * license identical to that listed in the included COPYING.OpenSSL
 * file, and distribute linked combinations including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <includes.h>
#include "nessus_plugin.h"
#include "comm.h"
#include "auth.h"
#include "parser.h"
#include "attack.h"
#include "context.h"
#include "preferences.h"

static void setup_plug_list(struct nessus_plugin *,struct nessus_plugin *, char *);


/*
 * restore_attack
 *
 * Restores a session
 *
 */
#ifdef ENABLE_SAVE_TESTS
void 
restore_attack(session_name, context)
  char * session_name;
  struct context *context;
{
  struct arglist * preferences = context->prefs;
  char * plug_list, * old_plug_list;
  struct nessus_plugin * plugs = context->plugins;
  struct nessus_plugin * scans = context->scanners;
  struct arglist * serv_prefs;
  int num_plug = 0;
  int num_scanners = 0;
  
  /* Count how many plugins we have */
  while(plugs != NULL ){
    num_plug++;
    plugs = plugs->next;
  }
  
  while(scans != NULL )
  {
   num_scanners++;
   scans = scans->next;
  }

  /*
   * Set up the plugin list, according to the
   * Nessus Transfer Protocol version 1.1
   */
  plug_list = emalloc(num_plug*20+1+num_scanners*20+1);
  setup_plug_list(context->plugins, context->scanners, plug_list);
  if( plug_list[0] == '\0' )
    sprintf(plug_list, "0");

  /* Add plugin_set to server preferences so it gets sent to the server */
  serv_prefs = arg_get_value(preferences, "SERVER_PREFS");
  if((old_plug_list = arg_get_value(serv_prefs, "plugin_set")))
   {
   efree(&old_plug_list);
   arg_set_type(serv_prefs, "plugin_set", ARG_STRING);
   arg_set_value(serv_prefs, "plugin_set", strlen(plug_list)+1, plug_list);
   }
  else
   arg_add_value(serv_prefs, "plugin_set", ARG_STRING, strlen(plug_list), plug_list);
  comm_send_preferences(context);
  comm_get_preferences_errors(context);
  preferences_save(context);
  comm_send_rules(context);
  comm_restore_session(context, session_name);
  /* efree(&plug_list); it is stored as SERVER_PREFS[plugin_set] */
}
#endif


/*
 * attack_host 
 *
 * This functions sends to the server (nessusd) the order
 * to start a new attack.
 *
 * Params :
 * 
 * hostname  : name of the host to test first
 * max_hosts : max number of hosts to test
 * recursive : unused
 * 
 */ 
int
attack_host(hostname, context)
  char * hostname;
  struct context *context;
{
  struct arglist * preferences = context->prefs;
  char * plug_list, * old_plug_list;
  struct nessus_plugin * plugs = context->plugins;
  struct nessus_plugin * scans = context->scanners;
  struct arglist * serv_prefs;
  int num_plug = 0;
  int num_scanners = 0;
  
  /* Count how many plugins we have */
  while(plugs != NULL ){
    num_plug++;
    plugs = plugs->next;
  }
  
  while(scans != NULL )
  {
   num_scanners++;
   scans = scans->next;
  }

  /*
   * Set up the plugin list, according to the
   * Nessus Transfer Protocol version 1.1
   */
  plug_list = emalloc(num_plug*20+1+num_scanners*20+1);
  setup_plug_list(context->plugins, context->scanners, plug_list);
  if( plug_list[0] == '\0' )
    sprintf(plug_list, "0");

  /* Add plugin_set to server preferences so it gets sent to the server */
  serv_prefs = arg_get_value(preferences, "SERVER_PREFS");
  if((old_plug_list = arg_get_value(serv_prefs, "plugin_set")))
   {
   efree(&old_plug_list);
   arg_set_type(serv_prefs, "plugin_set", ARG_STRING);
   arg_set_value(serv_prefs, "plugin_set", strlen(plug_list)+1, plug_list);
   }
  else
   arg_add_value(serv_prefs, "plugin_set", ARG_STRING, strlen(plug_list), plug_list);
  comm_send_preferences(context);
  comm_get_preferences_errors(context);
  preferences_save(context);
  comm_send_rules(context);
  network_printf(context->socket, "CLIENT <|> LONG_ATTACK <|>\n");
  network_printf(context->socket, "%d\n", strlen(hostname));
  if(context->socket > 0)
  {
   int len = strlen(hostname);
   int n = 0;
   /* send by packets of 1024 bytes */
   while(n < len)
   {
    int size = 1024;
    int m = 0;
    while(m < size)
    {
     int e;
     if((len - m - n) < size)size = len-m-n;
     e = nsend(context->socket, &(hostname[n+m]), size, 0);
     if(e < 0)
     {
      perror("send ");
      return 0;
     }
     m+=e;
    }
    n+=m;
   }
  /* network_printf("<|> CLIENT\n"); */
  /* network_printf("CLIENT <|> NEW_ATTACK <|> %s <|> CLIENT\n", hostname); */
  /* efree(&plug_list); (stored in SERVER_PREFS arglist) */
   return 1;
  }
  else
    return 0;
}

/*
 * setup_plug_list
 *
 * convert the ids of the plugins wich are enabled
 * to a string (ie : '1;3;4')
 */
static void
setup_plug_list(plugs, scanners, plug_list)
 struct nessus_plugin * plugs;
 struct nessus_plugin * scanners;
 char * plug_list;
{
 struct nessus_plugin * w = NULL;
 int i = 0;
 char sp[32];
 
 for(i=0;i<2;i++)
 {
  if(i == 0 )w = plugs;
  else w = scanners;
  
 while(w != NULL )
 {
  if( w->enabled )
    {
     snprintf(sp, sizeof(sp), "%d;", w->id);
     memcpy(plug_list, sp, strlen(sp) + 1);
     plug_list += strlen(sp);
    }
    w = w->next;
  }
 w = plugs;
 }
}
