# This script was written by Jeff Adams <jadams@netcentrics.com>
# This script is Copyright (C) 2003 Jeff Adams


if(description)
{
 script_id(11967);
 
 script_version("$Revision: 1.1 $");

 name["english"] = "DameWare Mini Remote Control Service Installed";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using DameWare Mini Remote Control Service. DameWare Mini 
Remote Control Service has been associated with security vulnerabilities in 
the past. Please verify version 3.73 or higher is installed.

Solution : Verify version 3.73 or higher is installed.
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Determines if DameWare Mini Remote Control Service is installed";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2003 Jeff Adams");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		    "smb_login.nasl","smb_registry_access.nasl",
		    "smb_registry_full_access.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
		     "SMB/domain","SMB/transport");

 script_require_ports(139, 445);
 exit(0);
}

include("smb_nt.inc");

rootfile = registry_get_sz(key:"SYSTEM\CurrentControlSet\Services\DWMRCS", item:"DisplayName");
if(rootfile)
{
 security_warning(get_kb_item("SMB/transport"));
}

