#TRUSTED 03f1455967342dac51067bfa936aac1687a745eb68a89f43ce52ee1fa1781b2337f09318ebf7c07191a755a33b63a503e244d8c7490bb47750059e568b45685eec4c2f7d5478047e6c93508dca1daa49504487403929999c54a2f79763750861b109e2bdb8baef62ad4a93297d7c1086f568c3760349cb25737e9528eb581678b03e8599192568846c1a5b2f3d174b1d916bd1ed7a55c49a963e3d2a7cf9c1bb1a7d457de28b061a228c3948f713d8206a69bb6e0bdfd4b0e0d5d0848af8412c2a6abfb5753749760b537891932330737331fe07368ed42e1e213c9020585bff51987b6c47e60e4eb476683f560c307a025dcc5f3891412bc210dbb10b0eb516ac226b9564dcc2355f91298a9e808a566dd7bb399d845ec895870ecbe2c17c1fe9f5e5c0a45248e6b59c2280a16e6f0aacd23b1e61115611a76b7cd920e39e2494adfcd30419d7a2d73beca26aa24bea26e035c2ee773fb81248f0b7f970171798c8bc213a9926df12830b9d3d6a85efb66ae90be4fa84ad525320414f532986426bfcfee5591a9584be485e00c31540a6fde86b8442e9ddfde02af85f042bb2f49db8ed53f820e0a009f16817c6628c3ba94dd3f92aca65f01080893f8bf1825563fe8af9abb11d71842cca5293004c9f6ac44e64ebea32a8ac7ec4a9198ef256c8645dfb82ea63b6ac35c8c9fcda88b91c5dcf9feaa507ba7a5e1148e2e70f
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15890);
 script_version ("1.3");
 name["english"] = "Hydra: VNC";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find VNC passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force VNC authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/passwords_file");
 script_require_ports("Services/vnc", 5900);
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "doublecheck_std_services.nasl", "vnc_security_types.nasl");
 exit(0);
}

#

force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
 thorough = get_kb_item("global_settings/thorough_tests");
 if ("yes" >!< thorough) exit(0);
}

port = get_kb_item("Services/vnc");
if (! port) exit(0); # port = 5900;
if (! get_port_state(port)) exit(0);

st = get_kb_item('VNC/SecurityType/'+port);
if (st == 1) exit(0);	# No auth

# Check that the VNC server is up and running
soc = open_sock_tcp(port);
if (! soc) exit(0);
r = recv(socket: soc, length: 512, min: 12);
close(soc);
if (strlen(r) < 12) exit(0);
v = eregmatch(string: r, pattern: '^RFB ([0-9]+)\\.([0-9]+)\n');
if (isnull(v)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
s = "";
if (empty) s = "n";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd != NULL)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (!s)
 exit(0);


if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "vnc";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*(login: *.*)? password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, p, '\n');
    set_kb_item(name: 'Hydra/vnc/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to find the following VNC passwords:\n' + report);
