#include <stdio.h>
#include <regex.h>

#include "base.h"
#include "escape.h"
#include "proc.h"

static unsigned long page_shift;
killer_t killer;


void fill_pcpu(proc_t * buf)
{
  unsigned long total_time;
  unsigned long pcpu = 0;
  unsigned long seconds;
 
    if (buf == NULL)
	return;			/* Just in case */

    total_time = buf->utime + buf->stime;

    seconds = uptime(0, 0)  -  ((unsigned long)buf->start_time) / Hertz;

    if (seconds)
	pcpu = (total_time * 1000ULL / Hertz) / seconds;
    buf->pcpu = (pcpu > 999) ? 999 : pcpu;
}

static procinfo_t *simple_spew(procinfo_t * tmp, int uid)
{
    proc_t buf;
    PROCTAB *ptp;
    //int check = 1;
    int i;
    int proc_table_size = PT_SIZE;
    
    procinfo_t *tmptmp;

    proc_table_size = PT_SIZE;
    tmp = malloc(proc_table_size * sizeof(procinfo_t));
    if (tmp == NULL) {
	/* XXX we should realy do something about this... */
	exit(-1);
    }
    ptp = openproc(PROC_FILLCMD | PROC_FILLENV | PROC_FILLUSR | PROC_FILLBUG);

    i = 0;
    memset(&buf, '#', sizeof(proc_t));
    while (readproc(ptp, &buf)) {
	if (buf.suid == uid || uid == -1) {
	    if (i > proc_table_size - 1) {	/* Pajtek */
		proc_table_size += PT_SIZE;
		tmptmp = realloc(tmp, proc_table_size * sizeof(procinfo_t));
		if (tmptmp == NULL) {
		    /* XXX some problems reallocating... */
		    exit(-1);
		}
		tmp = tmptmp;
	    }
	    tmp[i].proc = (proc_t *) malloc(sizeof(proc_t));
	    *(tmp[i].proc) = buf;	/* Pajtek */
#if DEBUG
	    printf("%i\n", tmp[i].proc->pid);
#endif
	    tmp[i].pmem = tmp[i].proc->rss * 1000 / PAGEDIV;
	    dev_to_tty(tmp[i].ttyc, TTYC, tmp[i].proc->tty,
		       tmp[i].proc->pid, ABBREV_DEV);
	    
	    /* in tree view, PID 1 is automatically expanded */
	    tmp[i].expand = (tmp[i].proc->pid == 1) ? 1 : 0;

	    tmp[i].is_selected = check_selection(tmp[i].proc->pid);

	    fill_pcpu(tmp[i].proc);
	    get_lc(&(tmp[i]));
	    
	    tmp[i].s_pname = strdup(tmp[i].pname);
	    
#if DEBUG
	    printf("%s\n", tmp[i].s_pname);
#endif
	    i++;
	    memset(&buf, '#', sizeof(proc_t));
	}
    }

    killer.count = i;

#if DEBUG
    for (i = 0; i < killer.count; i++) {
	printf("%i\n", tmp[i].proc->pid);
    }
#endif

#if DEBUG
    printf("loop over\n");
#endif

    closeproc(ptp);
    if (killer.count)
	return tmp;
    else
	return NULL;
}

void initplist(int view)
{

#if DEBUG
    int i;
#endif
    procinfo_t *tmp;		//, *hol;

#if DEBUG
    printf("initplist\n");
#endif

    meminfo();
    switch (getpagesize()) {
    case 65536:
	page_shift = 16;
	break;
    case 32768:
	page_shift = 15;
	break;
    case 16384:
	page_shift = 14;
	break;
    case 8192:
	page_shift = 13;
	break;
    default:
	fprintf(stderr, "Unknown page size! (assume 4096)\n");
    case 4096:
	page_shift = 12;
	break;
    case 2048:
	page_shift = 11;
	break;
    case 1024:
	page_shift = 10;
	break;
    }

    killer.monitoring = 0;
    killer.mother = NULL;

    killer.pidlist = simple_spew(tmp, view);

#if DEBUG
    printf("spew complete\n");
#endif

    killer.trunk = (procinfo_t *) calloc(killer.count, sizeof(procinfo_t));

#if DEBUG
    printf("killer.count %i\n", killer.count);
    for (i = 0; i < killer.count; i++) {
	printf("%s\n", killer.pidlist[i].pname);
    }
#endif
}

int find(killer_t *chow, int selected, char *input, int t_view) {
    
    regex_t preg;
    int tmp = selected + 1;
    int check = 1;
    int count;

    procinfo_t *list;

    if(t_view) {
	list = chow->trunk;
	count = chow->t_count;
    }
    else {
      list = chow->pidlist;
      count = chow->count;
    }

    if (regcomp(&preg, input, REG_ICASE | REG_NOSUB | REG_EXTENDED) != 0)
	return 0;

    while(tmp < count && check) {
	if (regexec(&preg, list[tmp].pname, 0, NULL, 0) != 0)
	    tmp++;
	else 
	    check = 0;
    }
    
    if (!check)
      return tmp;
    else
      return 0;
}

void search(killer_t *mother, char *input, int t_view)
{

  regex_t preg; 
    int i;
    int count;
    int pos;

    procinfo_t *list;
    
    if(t_view) {
      list = mother->trunk;
      count = mother->t_count;
    }
    else {
      list = mother->pidlist;
      count = mother->count;
    }
    
    if (regcomp(&preg, input, REG_ICASE | REG_NOSUB | REG_EXTENDED) != 0)
	return;

    for (i = 0; i < count; i++) {
	if (regexec(&preg, list[i].pname, 0, NULL, 0) == 0) {
	  pos = pid_pos(list[i].proc->pid, mother->pidlist, mother->count);
	  mother->pidlist[pos].is_selected = 1;
	}
    }

}


void get_lc(procinfo_t * input)
{
    char tag[130], buf[64];
    const char **lc = (const char **) input->proc->cmdline;

    if (lc && *lc) {
      escape_strlist(tag, lc, 128);
    } else {
      /* cmd between '[' and ']' */
      escape_str(buf, input->proc->cmd, 64);
      snprintf(tag, strlen(buf) + 3, "%s", buf);
      tag[strlen(buf) + 3] = '\0';
    }
    
    input->pname = strdup(tag);
#if DEBUG
	printf("get_lc: %s\n", input->pname);
#endif
}


void monitor(killer_t * mother)
{
    int i;

    mother->son = (killer_t *) malloc(sizeof(killer_t));

    mother->son->pidlist = (procinfo_t *) calloc(mother->count, sizeof(procinfo_t));
    mother->son->trunk = (procinfo_t *) calloc(mother->count, sizeof(procinfo_t));

    mother->son->monitoring = 1;
    mother->son->mother = mother;

    mother->son->count = 0;
    mother->son->t_count = 0;

    for (i = 0; i < mother->count; i++) {
	if (mother->pidlist[i].is_selected) {
	    dup_procinfo_t(&(mother->son->pidlist[mother->son->count]), &(mother->pidlist[i]));
	    mother->son->pidlist[mother->son->count].s_pname = strdup(mother->son->pidlist[mother->son->count].pname);
	    mother->son->count++;
	}
    }
}


void selective_spew(killer_t * chow)
{
    procinfo_t *tmp;		//, *hold;

    proc_t buf;
    pid_t *list_buf;
    PROCTAB *ptp;
    int i;
    int j;
    int check;
    int proc_table_size = PT_SIZE;

    list_buf = (pid_t *) calloc(chow->count, sizeof(pid_t));

    for (i = 0; i < chow->count; i++) {
	list_buf[i] = chow->pidlist[i].proc->pid;
#if DEBUG
	printf("%i\n", list_buf[i]);
#endif
    }

    proc_table_size += PT_SIZE;
    memset(&buf, '#', sizeof(proc_t));
    tmp = malloc(proc_table_size * sizeof(procinfo_t));

    ptp = openproc(PROC_FILLCMD | PROC_FILLENV | PROC_FILLUSR | PROC_FILLBUG);

    i = 0;
    while (readproc(ptp, &buf) && i < chow->count) {
	j = 0;
	check = 1;
	while (j < chow->count && check) {
	    if (buf.pid == list_buf[j]) {
#if DEBUG
		printf("%i", buf.pid);
#endif
		if (i > proc_table_size - 1) {	/* Pajtek */
		    proc_table_size += PT_SIZE;
		    tmp = realloc(tmp, proc_table_size * sizeof(procinfo_t));
		}
		tmp[i].proc = (proc_t *) malloc(sizeof(proc_t));
		*(tmp[i].proc) = buf;	/* Pajtek */
#if DEBUG
		printf("%i\n", tmp[i].proc->pid);
#endif
		tmp[i].pmem = tmp[i].proc->rss * 1000 / PAGEDIV;
		dev_to_tty(tmp[i].ttyc, TTYC, tmp[i].proc->tty,
			   tmp[i].proc->pid, ABBREV_DEV);
		tmp[i].expand = 0;
		tmp[i].is_selected = check_selection(tmp[i].proc->pid);

		fill_pcpu(tmp[i].proc);
		get_lc(&(tmp[i]));
		tmp[i].s_pname = strdup(tmp[i].pname);
#if DEBUG
		printf("%s\n", tmp[i].pname);
#endif
		check = 0;
		i++;
	    } else
		j++;
	}
	memset(&buf, '#', sizeof(proc_t));
    }

    closeproc(ptp);

    free(list_buf);

    chow->pidlist = tmp;
    chow->trunk = (procinfo_t *) calloc(i, sizeof(procinfo_t));

    chow->count = i;
    chow->t_count = 0;

    chow->trunk = (procinfo_t *) calloc(chow->count, sizeof(procinfo_t));
}

int check_selection(int pid)
{

  int i = 0;
  
  while(selection_template[i] != -1) {

    if (pid == selection_template[i])
      return 1;
    else
      i++;
  }

  return 0;

}

void refresh_stemplate(killer_t * mother)
{      
    int i;
    int j = 0;		
 
    template_size = PT_SIZE;
    selection_template = (int * ) malloc(template_size * sizeof(int));
    
      for (i = 0; i < mother->count; i++) {
	if (mother->pidlist[i].is_selected == 1) {

	    if (j > template_size - 2) {  /* Pajtek */
		template_size += PT_SIZE;
		selection_template = realloc(selection_template, template_size * sizeof(int));
	    }
	    selection_template[j] = mother->pidlist[i].proc->pid;
	    j++;
	}
      }
      selection_template[j] = -1;
}

void shell_sort(procinfo_t *pidlist, int tag, int count) {

    int gap;
    int i;
    int swap;
    long diff;
    procinfo_t temp;
    static int key_buf = 0;
    static int key_comp = 0;

    temp.proc = NULL;
    
    if(tag != -1) {
	if(key_buf == tag)
	    key_comp = (key_comp + 1) % 2;
    } else
	tag = key_buf;

    if(count % 2)
	gap = (count + 1) / 2;
    else
	gap = count / 2;


    while (gap > 0) {
	swap = 1;
	while(swap == 1) {
	    swap = 0;
	    for(i = 0; i < count - gap; i++) {
		if(tag == KEY_F(1) || tag == '1')
		    diff = pidlist[i].proc->suid - pidlist[i + gap].proc->suid;
		else if (tag == KEY_F(2) || tag == '2')
		    diff = alpha(pidlist[i].ttyc, pidlist[i + gap].ttyc);
		else if(tag == KEY_F(3) || tag == '3')
		    diff = pidlist[i].proc->pid - pidlist[i + gap].proc->pid;
		else if (tag == KEY_F(4) || tag == '4')
		    diff = (long) pidlist[i].proc->pcpu - (long) pidlist[i + gap].proc->pcpu;
		else if (tag == KEY_F(5) || tag == '5')
		    diff = pidlist[i].pmem - pidlist[i + gap].pmem;
		else if (tag == KEY_F(6) || tag == '6')
		  diff = pidlist[i].proc->nice - pidlist[i + gap].proc->nice;
		else if (tag == KEY_F(7) || tag == '7')
		  diff = (long) (pidlist[i].proc->state - pidlist[i + gap].proc->state);
		else if (tag == KEY_F(8) || tag == '8')
		  diff = alpha(pidlist[i].pname, pidlist[i + gap].pname);
		else
		    diff = 0;

		diff *= pow(-1, key_comp);

		if (diff < 0) {
		    temp = pidlist[i];
		    pidlist[i] = pidlist[i + gap];
		    pidlist[i + gap] = temp;
		    swap = 1;
		}

	    }
	}
	if(gap % 2 && gap != 1)
	    gap = (gap + 1) / 2;
	else
	    gap = gap / 2;
    }

    key_buf = tag;

}

int pid_pos(pid_t pid, procinfo_t *pidlist, int count) {

    int i;
    int check;

    check = 1;
    i = 0;

    while(check && i < count) {	
	if (pidlist[i].proc->pid == pid)
	    check = 0;
	else
	    i++;
    }

    if(i < count)
	return i;
    else
	return -1;

}

int alpha(char *string1, char *string2) {

    int i = 0;
    int check = 1;
    int diff;

    while(string1[i] != '\0' && string2[i] != '\0' && check) {

	if(string1[i] != string2[i]) {
	    check = 0;
	    diff = string2[i] - string1[i];
	} else
	    i++;

    }

    return diff;

}

void dup_procinfo_t(procinfo_t *target, procinfo_t *orig) {
    
    memcpy(target, orig, sizeof(procinfo_t));
    target->pname = NULL;
    target->s_pname = NULL;
        
    target->proc = (proc_t *) malloc(sizeof(proc_t));
    memset(target->proc, '#', sizeof(proc_t));
    memcpy(target->proc, orig->proc, sizeof(proc_t));
    target->pname = strdup(orig->pname);
    /*  target->s_pname = strdup(orig->s_pname); */
    strcpy(target->proc->suser, orig->proc->suser);
    
    strcpy(target->proc->cmd, orig->proc->cmd);
    strcpy(target->ttyc, orig->ttyc);
    target->proc->environ = NULL;
    target->proc->cmdline = NULL;

}

void free_list(procinfo_t *pidlist, int count) {

    int i;
    
    for(i = 0; i < count; i++) {
	freeproc(pidlist[i].proc);
	if(pidlist[i].pname)
	    free(pidlist[i].pname);
	  	
	if(pidlist[i].s_pname)
	  free(pidlist[i].s_pname);
    }
    
    free(pidlist);
}
