/*
 * NASPRO - The NASPRO Architecture for Sound Processing
 * Core library
 *
 * Copyright (C) 2007-2012 NASPRO core development team
 *
 * See the COPYING file for license conditions.
 */

#define _WIN32_WINNT	0x501
#define UNICODE

#include "internal.h"

#include <windows.h>

_NACORE_DEF nacore_locale _nacore_locale_global = "";

_NACORE_DEF nacore_locale
nacore_locale_new(int category_mask, const char *locale, nacore_locale base)
{
	char *oldloc, *newloc;
	int oldlts;
	nacore_locale ret;
	int err = 0;

	oldlts = _configthreadlocale(0);
	if (oldlts == _ENABLE_PER_THREAD_LOCALE)
		oldloc = setlocale(LC_ALL, NULL);
	else
		_configthreadlocale(_ENABLE_PER_THREAD_LOCALE);

	if (category_mask == NACORE_LOCALE_ALL_MASK)
	  {
		newloc = setlocale(LC_ALL, locale);
		if (newloc == NULL)
		  {
			ret = NULL;
			err = ENOENT;
			goto _err;
		  }
	  }
	else
	  {
		setlocale(LC_ALL, (base != NULL) ? base : "C");

		if (category_mask & NACORE_LOCALE_COLLATE_MASK)
			if (setlocale(LC_COLLATE, locale) == NULL)
			  {
				ret = NULL;
				err = ENOENT;
				goto _err;
			  }
		if (category_mask & NACORE_LOCALE_CTYPE_MASK)
			if (setlocale(LC_CTYPE, locale) == NULL)
			  {
				ret = NULL;
				err = ENOENT;
				goto _err;
			  }
		if (category_mask & NACORE_LOCALE_MONETARY_MASK)
			if (setlocale(LC_MONETARY, locale) == NULL)
			  {
				ret = NULL;
				err = ENOENT;
				goto _err;
			  }
		if (category_mask & NACORE_LOCALE_NUMERIC_MASK)
			if (setlocale(LC_NUMERIC, locale) == NULL)
			  {
				ret = NULL;
				err = ENOENT;
				goto _err;
			  }
		if (category_mask & NACORE_LOCALE_TIME_MASK)
			if (setlocale(LC_TIME, locale) == NULL)
			  {
				ret = NULL;
				err = ENOENT;
				goto _err;
			  }

		newloc = setlocale(LC_ALL, NULL);
	  }

	ret = nacore_strdup(newloc, NULL);
	if (ret == NULL)
	  {
		err = ENOMEM;
		goto _err;
	  }

	if (base != NULL)
		free(base);

_err:
	if (oldlts == _ENABLE_PER_THREAD_LOCALE)
		setlocale(LC_ALL, oldloc);
	else
		_configthreadlocale(_DISABLE_PER_THREAD_LOCALE);

	if (err != 0)
		errno = err;

	return ret;
}

_NACORE_DEF void
nacore_locale_free(nacore_locale locale)
{
	free(locale);
}

_NACORE_DEF nacore_locale
nacore_locale_dup(nacore_locale locale)
{
	return nacore_strdup((locale != _nacore_locale_global)
			     ? locale : setlocale(LC_ALL, NULL), NULL);
}

_NACORE_DEF nacore_locale
nacore_locale_use(nacore_locale locale)
{
	nacore_locale ret;

	if (_configthreadlocale(0) == _ENABLE_PER_THREAD_LOCALE)
		ret = setlocale(LC_ALL, NULL);
	else
		ret = _nacore_locale_global;

	if (locale == _nacore_locale_global)
		_configthreadlocale(_DISABLE_PER_THREAD_LOCALE);
	else
	  {
		_configthreadlocale(_ENABLE_PER_THREAD_LOCALE);
		setlocale(LC_ALL, locale);
	  }

	return ret;
}

/* FIXME: should probably use lconv->_W_decimal_point to properly handle Unicode
 * decimal separators like the Persian Momayyez. */

NACORE_PRIVATE size_t
_nacore_locale_dec_sep_len()
{
	struct lconv *lconv = localeconv();

	return strlen(lconv->decimal_point);
}

NACORE_PRIVATE void
_nacore_locale_dec_sep_get(char *buf)
{
	struct lconv *lconv = localeconv();

	strcpy(buf, lconv->decimal_point);
}
