--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
function Ada.Containers.Vectors.Select_Item (Item : Vector;
                                             Select_On : Selection_Type)
return Cursor is
   Current_Cursor : Cursor;
begin
   Current_Cursor := First (Item);
   loop
      exit when Current_Cursor = No_Element;
      if Selection (Element (Current_Cursor), Select_On) then
         return Current_Cursor;
      end if;
      Current_Cursor := Next (Current_Cursor);
   end loop;
   return Current_Cursor;
end Ada.Containers.Vectors.Select_Item;
