--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Strings.Unbounded;

package Shell_Commands is

   type Command_Type is (Get, Help, Launch, Send_Order, Set, Load,
                         Sleep, Wait, Echo, Dump, Group,
                         Special_Domi);

   function Find (Shell_Line : String) return Command_Type;
   function Find (Shell_Line : Ada.Strings.Unbounded.Unbounded_String)
                 return Command_Type;
   type Arguments_Array is array (Positive range <>) of
     Ada.Strings.Unbounded.Unbounded_String;
   function Arguments (Shell_Line : String) return Arguments_Array;
   Bad_Command : exception;
   No_Argument : exception;
   No_Command : exception;

   type Status_Type is (Ok, Syntax_Error, Error);

end Shell_Commands;
