--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with McKae.XML.EZ_Out.String_Stream;

package body Narval.Partitions is

   use type Ada.Strings.Unbounded.Unbounded_String;

   ---------------------------
   -- Liste_Fixe_Partitions --
   ---------------------------

   protected body Partition_Shell_Type is

      -------------
      -- Ajouter --
      -------------

      procedure Add
        (Name : String;
         Config : Configuration_Access;
         Host_Name : String)
      is
         Uncontrained_Name : constant Ada.Strings.Unbounded.Unbounded_String :=
           Ada.Strings.Unbounded.To_Unbounded_String (Name);
         Uncontrained_Host_Name :
           constant Ada.Strings.Unbounded.Unbounded_String :=
           Ada.Strings.Unbounded.To_Unbounded_String (Host_Name);
      begin
         Partition_Vector_Package.Append (Partitions,
                                    (Name => Uncontrained_Name,
                                     Configuration_Hook => Config,
                                     Host_Name => Uncontrained_Host_Name));
      end Add;

      -------------
      -- Enlever --
      -------------

      procedure Remove (Name : String) is
         Uncontrained_Name : constant Ada.Strings.Unbounded.Unbounded_String :=
           Ada.Strings.Unbounded.To_Unbounded_String (Name);
         The_Cursor : Partition_Vector_Package.Cursor;
         use type Partition_Vector_Package.Cursor;
      begin
         The_Cursor := Partition_Vector_Package.First (Partitions);
         loop
            exit when The_Cursor = Partition_Vector_Package.No_Element;
            declare
               Current_Partition : constant Partition_Type :=
                 Partition_Vector_Package.Element (The_Cursor);
            begin
               if Current_Partition.Name = Uncontrained_Name then
                  Partition_Vector_Package.Delete (Partitions, The_Cursor);
                  return;
               end if;
            end;
            The_Cursor := Partition_Vector_Package.Next (The_Cursor);
         end loop;
      end Remove;

      ---------------------
      -- Noms_Partitions --
      ---------------------

      function Name_All_Partitions return String is
         use Ada.Strings.Unbounded;
         use McKae.XML.EZ_Out.String_Stream.String_Buffering;
         use McKae.XML.EZ_Out.String_Stream.XML_String_Buffer;
         Xml_Buffer : String_Buffer;
         Length : constant Ada.Containers.Count_Type :=
           Partition_Vector_Package.Length (Partitions);
         The_Cursor : Partition_Vector_Package.Cursor;
         use type Partition_Vector_Package.Cursor;
      begin
         Current_Format := McKae.XML.EZ_Out.Continuous_Stream;
         Start_Element (Xml_Buffer, "result",
                        ("cmd" = "get", "status" = "OK"));
         Start_Element (Xml_Buffer, "data",
                        ("sub_system_number" = Natural (Length),
                         "type" = "string",
                         "name" = "sub_systems"));
         if Partition_Vector_Package.Is_Empty (Partitions) then
            Output_Element (Xml_Buffer, "value", "");
         else
            The_Cursor := Partition_Vector_Package.First (Partitions);
            loop
               exit when The_Cursor = Partition_Vector_Package.No_Element;
               declare
                  Partition : constant Partition_Type :=
                    Partition_Vector_Package.Element (The_Cursor);
               begin
                  Output_Element (Xml_Buffer, "value",
                                  To_String (Partition.Name));
               end;
               The_Cursor := Partition_Vector_Package.Next (The_Cursor);
            end loop;
         end if;
         End_Element (Xml_Buffer, "data");
         End_Element (Xml_Buffer, "result");
         declare
            String_To_Return : constant String := Get_String (Xml_Buffer);
         begin
            Full_Clear (Xml_Buffer);
            return String_To_Return;
         end;
      end Name_All_Partitions;

      -----------------------
      -- Nombre_Partitions --
      -----------------------

      function Number_Of_Partitions return Natural is
      begin
         return Natural (Partition_Vector_Package.Length (Partitions));
      end Number_Of_Partitions;

      -------------------
      -- Configuration --
      -------------------

      function Configuration (Name : String) return Configuration_Access
      is
         Uncontrained_Name : constant Ada.Strings.Unbounded.Unbounded_String :=
           Ada.Strings.Unbounded.To_Unbounded_String (Name);
         The_Cursor : Partition_Vector_Package.Cursor;
         use type Partition_Vector_Package.Cursor;
      begin
         if Partition_Vector_Package.Is_Empty (Partitions) then
            raise Unknown_Sub_System;
         end if;
         The_Cursor := Partition_Vector_Package.First (Partitions);
         loop
            exit when The_Cursor = Partition_Vector_Package.No_Element;
            declare
               Partition : constant Partition_Type :=
                 Partition_Vector_Package.Element (The_Cursor);
            begin
               if Uncontrained_Name = Partition.Name then
                  return Partition.Configuration_Hook;
               end if;
            end;
            The_Cursor := Partition_Vector_Package.Next (The_Cursor);
         end loop;
         raise Unknown_Sub_System;
      end Configuration;

      function Exist (Name : String) return Boolean is
         Uncontrained_Name : constant Ada.Strings.Unbounded.Unbounded_String :=
           Ada.Strings.Unbounded.To_Unbounded_String (Name);
         The_Cursor : Partition_Vector_Package.Cursor;
         use type Partition_Vector_Package.Cursor;
      begin
         if Partition_Vector_Package.Is_Empty (Partitions) then
            return False;
         end if;
         The_Cursor := Partition_Vector_Package.First (Partitions);
         loop
            exit when The_Cursor = Partition_Vector_Package.No_Element;
            declare
               Partition : constant Partition_Type :=
                 Partition_Vector_Package.Element (The_Cursor);
            begin
               if Uncontrained_Name = Partition.Name then
                  return True;
               end if;
            end;
            The_Cursor := Partition_Vector_Package.Next (The_Cursor);
         end loop;
         return False;
      end Exist;

      procedure Trig_Event (Event : String) is
         The_Cursor : Partition_Vector_Package.Cursor;
         use type Partition_Vector_Package.Cursor;
      begin
         if Partition_Vector_Package.Is_Empty (Partitions) then
            return;
         end if;
         The_Cursor := Partition_Vector_Package.First (Partitions);
         loop
            exit when The_Cursor = Partition_Vector_Package.No_Element;
            declare
               Partition : constant Partition_Type :=
                 Partition_Vector_Package.Element (The_Cursor);
               Configuration_Hook : constant Configuration_Access :=
                 Partition.Configuration_Hook;
            begin
               Trig_Event (Configuration_Hook, Event);
            end;
            The_Cursor := Partition_Vector_Package.Next (The_Cursor);
         end loop;
      end Trig_Event;
   end Partition_Shell_Type;

end Narval.Partitions;
