--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------

--  wsdl2aws SOAP Generator v2.0
--
--  AWS 2.2.0 - SOAP 1.4.0
--  This file was generated on Wednesday 06 February 2008 at 10:05:06
--
--  $ wsdl2aws -spec narval_aws_interface -f
--  -main aws_interface_main -cb narval_aws.wsdl

with AWS.Config.Set;
pragma Elaborate_All (AWS.Config.Set);
with AWS.Server;
pragma Elaborate_All (AWS.Server);
with AWS.Status;
pragma Elaborate_All (AWS.Status);
with AWS.Response;
pragma Elaborate_All (AWS.Response);
with SOAP.Dispatchers.Callback;
pragma Elaborate_All (SOAP.Dispatchers.Callback);

with narval_aws_Service.CB;
pragma Elaborate_All (narval_aws_Service.CB);
with narval_aws_Service.Server;
pragma Elaborate_All (narval_aws_Service.Server);

with Options;

procedure aws_interface_main is

   use AWS;

   function CB
     (Request : in Status.Data)
     return Response.Data;

   function CB
     (Request : in Status.Data)
     return Response.Data
   is
      pragma Unreferenced (Request);
      R : Response.Data;
   begin
      return R;
   end CB;

   WS   : AWS.Server.HTTP;
   Conf : Config.Object;
   Disp : narval_aws_Service.CB.Handler;

   function Get_Port is new
     Options.Get_Integer_Number (Integer);

begin
   if Options.Present_Option ("aws_server_port") then
      Config.Set.Server_Port (Conf, Get_Port ("aws_server_port"));
   else
      Config.Set.Server_Port
        (Conf, narval_aws_Service.Server.Port);
   end if;
   Disp := SOAP.Dispatchers.Callback.Create
     (CB'Unrestricted_Access,
      narval_aws_Service.CB.SOAP_CB'Access);

   AWS.Server.Start (WS, Disp, Conf);

   AWS.Server.Wait (AWS.Server.Forever);
end aws_interface_main;
