#include <stdlib.h>
#include <stdio.h>

static int next_id = 0;
struct my_struct
{
  int id;
};

/* you must have the following symbols */
/* see John Cresswell document for details : */
/* AGATA PSA and Tracking Algorithm Integration*/
void process_config (char *directory_path, unsigned int *error_code);
struct my_struct *process_register (unsigned int *error_code);
/* the call of this routine is different from the one in the document */
/* because document discribe filter interface and here we consume data */
/* ask X. Grave grave@ipno.in2p3.fr for more details */
void process_block (struct my_struct *algo_data,
		    void *input_buffer,
		    unsigned int size_of_input_buffer,
		    unsigned int *error_code);
/* optionnal symbols */
void process_initialise (struct my_struct *algo_data,
			 unsigned int *error_code);
void process_reset (struct my_struct *algo_data,
		    unsigned int *error_code);
void process_start (struct my_struct *algo_data,
		    unsigned int *error_code);
void process_stop (struct my_struct *algo_data,
		   unsigned int *error_code);
void process_pause (struct my_struct *algo_data,
		    unsigned int *error_code);
void process_resume (struct my_struct *algo_data,
		     unsigned int *error_code);
void process_unload (struct my_struct *algo_data,
		     unsigned int *error_code);

/* coding region */

void process_config (char *directory_path, unsigned int *error_code)
{
  printf ("call to process_config\n");
  printf ("directory path = %s\n",directory_path);
  *error_code = 0;
}

struct my_struct *process_register (unsigned int *error_code)
{
  struct my_struct *algo_data;

  algo_data = (struct my_struct *) malloc (sizeof (struct my_struct));
  algo_data->id = next_id;
  next_id++;
  return algo_data;
}

void process_block (struct my_struct *algo_data,
		    void *input_buffer,
		    unsigned int size_of_input_buffer,
		    unsigned int *error_code)
{
  unsigned int size_of_input_buffer_in_32_bits_word;
  unsigned int *data;

  size_of_input_buffer_in_32_bits_word = size_of_input_buffer / 4;
  data = (unsigned int *) input_buffer;
  printf ("data [0] = %d\n",(int) data [0]);
  *error_code = 0;
}

void process_initialise (struct my_struct *algo_data,
			 unsigned int *error_code)
{
  printf ("process_initialise called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_reset (struct my_struct *algo_data,
		    unsigned int *error_code)
{
  printf ("process_reset called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_start (struct my_struct *algo_data,
		    unsigned int *error_code)
{
  printf ("process_start called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_stop (struct my_struct *algo_data,
		   unsigned int *error_code)
{
  printf ("process_stop called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_pause (struct my_struct *algo_data,
		    unsigned int *error_code)
{
  printf ("process_pause called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_resume (struct my_struct *algo_data,
		     unsigned int *error_code)
{
  printf ("process_resume called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_unload (struct my_struct *algo_data,
		     unsigned int *error_code)
{
  printf ("process_unload called with id=%d\n",algo_data->id);
  /* put your code here */
  free (algo_data);
  *error_code = 0;
}
