/****************************************************************************

COPYRIGHT NOTICE:

  The source code in this file is provided free of charge
  to the author's consulting clients.  It is in the
  public domain and therefore may be used by anybody for
  any purpose.

AUTHOR:

  Will Naylor

****************************************************************************/
#include "wnlib.h"
#include "wnrtab.h"
#include "wnasrt.h"

#include "wnhash.h"



int wn_memhash(ptr key,int len)
{
  extern int wn_random_int_table[];
  register int ret;
  register int *random_int_table;
  register char *ckey;

  ckey = (char *)key;

  random_int_table = wn_random_int_table + 260;

  ret = random_int_table[*(char *)key];

small:
  switch(len)
  {
    case(8):   
		ret ^= (ret >> 5);
                ret ^= random_int_table[*(++ckey)];
    case(7):   
		ret ^= (ret << 17);
                ret ^= random_int_table[*(++ckey)];
    case(6):   
		ret ^= (ret >> 19);
                ret ^= random_int_table[*(++ckey)];
    case(5):   
		ret ^= (ret << 11);
                ret ^= random_int_table[*(++ckey)];
    case(4):   
		ret ^= (ret >> 13);
                ret ^= random_int_table[*(++ckey)];
    case(3):   
		ret ^= (ret << 3);
                ret ^= random_int_table[*(++ckey)];
    case(2):   
		ret ^= (ret >> 7);
                ret ^= random_int_table[*(++ckey)];
    case(1):   
		return(ret);
    case(0):   
                return(0);
    default:
    {
      wn_assert(len > 8);

      for(;len > 8;len -= 8)
      {
	ret ^= (ret >> 5);
        ret ^= random_int_table[*(++ckey)];

	ret ^= (ret << 17);
        ret ^= random_int_table[*(++ckey)];

	ret ^= (ret >> 19);
        ret ^= random_int_table[*(++ckey)];

	ret ^= (ret << 11);
        ret ^= random_int_table[*(++ckey)];

	ret ^= (ret >> 13);
        ret ^= random_int_table[*(++ckey)];

        ret ^= (ret << 3);
        ret ^= random_int_table[*(++ckey)];

        ret ^= (ret >> 2);
        ret ^= random_int_table[*(++ckey)];

	ret ^= (ret << 7);
        ret ^= random_int_table[*(++ckey)];
      }

      goto small;
    }
  }
}


