/*
 * Ostatnia aktualizacja:
 *
 * - $Id: utils.c,v 1.28 2003/01/09 12:21:02 mati Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>

#include "libtlen.h"

/*
 * int debug
 *
 * zmienna ze stanem wiadomoci debuga (w/wy)
 * domylnie wyczone
 *
 */

int debug = 0;

/*
 * tlen_ping()
 *
 * Wysya pakiet kontrolny keep-alive do serwera
 *
 * - sesja - identyfikator sesji
 *
 * Ping powinien by wysyany co okoo 60 sekund
 */
 
void tlen_ping(struct tlen_session *sesja)
{
	tlen_socket_write_string (sesja, "  \t  ");
}

/*
 * tlen_encode()
 *
 * Koduje tekst przy pomocy urlencode
 *
 * - what - tekst ktry chcemy zakodowa
 *
 * Dla zwracanego tekstu alokowana jest pami, trzeba go
 * zwolni przy uyciu free()
 *
 */

char *tlen_encode (const char *what)
{
	if (what)
	{
		const unsigned char *s = what;
		unsigned char *ptr, *str;

		str = ptr = (unsigned char *) calloc (3 * strlen (s) + 1,1);
		if (!str)
			return 0;
		while (*s)
		{
			if (*s == ' ')
				*ptr++ = '+';
			else if ((*s < '0' && *s != '-' && *s != '.')
				 || (*s < 'A' && *s > '9') || (*s > 'Z'
							       && *s < 'a'
							       && *s != '_')
				 || (*s > 'z'))
			{
				sprintf (ptr, "%%%02X", *s);
				ptr += 3;
			}
			else
				*ptr++ = *s;
			s++;
		}
		return str;
	}
	return 0;
}

/*
 * tlen_decode()
 *
 * Dekoduje tekst przy pomocy urldecode
 *
 * - what - tekst ktry chcemy rozkodowa
 *
 * Dla zwracanego tekstu alokowana jest pami, trzeba go
 * zwolni przy uyciu free()
 *
 */

char *tlen_decode(const char *what)
{
	if (what)
	{
		unsigned char *dest, *data, *retval;
		dest = data = retval = strdup (what);
		if (!data)
			return 0;

		while (*data)
		{
			if (*data == '+')
				*dest++ = ' ';
			else if ((*data == '%') && isxdigit ((int) data[1])
				 && isxdigit ((int) data[2]))
			{
				int code;
				sscanf (data + 1, "%2x", &code);
				if (code != '\r')
					*dest++ = (unsigned char) code;
				data += 2;
			}
			else
				*dest++ = *data;
			data++;
		}
		*dest = '\0';
		return retval;
	}
	return 0;
}

/*
 * tlen_debug_raw()
 *
 * Wywietla na stderr tekst pomocniczy przy debugowaniu
 *
 * - name - nazwa funkcji z ktrej debug zosta wywoany
 * - format - format tekstu do wywietlenia
 * - ... - wywietlany tekst(y)
 *
 * Funkcja wewntrzna, naley uywa wrappera tlen_debug(),
 * ktry automatycznie wypenia pierwsze pole (name)
 *
 */

void tlen_debug_raw(const char *name, char *format, ...) {
    if (debug==1) {
	va_list ap;
	va_start (ap, format);
	printf("--- %s ---\n",name);
	vprintf (format, ap);
	va_end (ap);
    }
}

/*
 * tlen_stripresource()
 *
 * Usuwa z podanego tekstu wszystko co po znaku /
 *
 * - jid - tekst z ktrego ma zosta usuniety "resource"
 *
 * Uywane dla identyfikatorw jabbera dla przychodzcych
 * zapyta (uytkownik@tlen.pl/t). Tekst zamieniany jest
 * bezporednio w pamici.
 *
 */

int tlen_stripresource (char *jid)
{
    if (strchr(jid,'/')) *strchr(jid,'/')=0;
    return 1;
}

/*
 * tlen_setdebug()
 *
 * Pozwala na ustawianie, czy wiadomoci debug maj by
 * wywietlane, czy nie
 *
 * - dbg - wcz/wycz, odpowiednio 0/1
 *
 */

int tlen_setdebug (int dbg)
{
    debug = dbg;
    return debug;
}

/*
 * static char tlen_base64_charset[]
 *
 * Tablica znakw dla funkcji kodujcych base64
 *
 */

static char tlen_base64_charset[] = 
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

/*
 * tlen_base64_encode()
 *
 * Funkcja kodujca tekst przy uyciu base64
 *
 * - buf - tekst do zakodowania
 *
 * Warto zwracana jest alokowana, naley zwolni przez free()
 *
 */

char *tlen_base64_encode(const char *buf)
{
    char *out, *res;
    int i = 0, j = 0, k = 0, len = strlen(buf);
    
    res = out = malloc((len / 3 + 1) * 4 + 2);
    
    if (!res)
	return NULL;
	
    while (j <= len) {
	switch (i % 4) {
	    case 0:
		k = (buf[j] & 252) >> 2;
		break;
	    case 1:
		if (j < len)
		    k = ((buf[j] & 3) << 4) | ((buf[j + 1] & 240) >> 4);
		else
		    k = (buf[j] & 3) << 4;
		    
		j++;
		break;
	    case 2:
		if (j < len)
		    k = ((buf[j] & 15) << 2) | ((buf[j + 1] & 192) >> 6);
		else
		    k = (buf[j] & 15) << 2;
		    
		j++;
		break;
	    case 3:
		k = buf[j++] & 63;
		break;
	}
	*out++ = tlen_base64_charset[k];
	i++;
    }
    
    if (i % 4)
	for (j = 0; j < 4 - (i % 4); j++, out++)
	    *out = '=';
	    
    *out = 0;
    
    return res;
}

/*
 * tlen_base64_decode()
 *
 * Funkcja dekodujca tekst przy uyciu base64
 *
 * - buf - tekst do zdekodowania
 *
 * Warto zwracana jest alokowana, naley zwolni przez free()
 *
 */

char *tlen_base64_decode(const char *buf)                                         
{                                                                               
    char *res, *save, *foo, val;                                            
    const char *end;                                                        
    int index = 0;                                                          

    if (!buf)                                                               
        return NULL;                                                    

    save = res = calloc(1, (strlen(buf) / 4 + 1) * 3 + 2);                  

    if (!save)                                                              
        return NULL;                                                    

    end = buf + strlen(buf);                                                

    while (*buf && buf < end) {                                             
        if (*buf == '\r' || *buf == '\n') {                             
            buf++;                                                  
	    continue;
	}

        if (!(foo = strchr(tlen_base64_charset, *buf)))                   
            foo = tlen_base64_charset;                                

        val = (int)foo - (int)tlen_base64_charset;                        
																													                buf++;                                                          
        switch (index) {                                                
	    case 0:                                                 
		*res |= val << 2;                               
		break;																																								                                                              	
	    case 1:		    																																										                                
                *res++ |= val >> 4;                             
                *res |= val << 4;                               
                break;                          
            case 2:                                                 
                *res++ |= val >> 2;                             
                *res |= val << 6;                               
                break;                                          
            case 3:                                                 
                *res++ |= val;                                  
                break;                                          
	}                                                               
	index++;                                                        
	index %= 4;                                                     
    }                                                                       
    *res = 0;                                                               

    return save;                                                            
}         
