/*  tilp - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_TIVARS_83__
#define __TIFFEP_TIVARS_83__

#include "tiffep.h"

/*************************/
/* Structure definitions */
/*************************/

/* TI83 calculators */

/*
  This structure is used for storing a real
*/
struct real_number_83_
{
  // TI encoding
  byte flags;
  byte exponent[1];
  byte mantissa[7];
};
typedef struct real_number_83_ RealNumber_83;

/*
  This structure is used for storing a complex number
*/
struct complex_number_83_
{
  RealNumber_83 real_part;
  RealNumber_83 imag_part;
};
typedef struct complex_number_83_ CplxNumber_83;

/*
  This structure is used for storing a real list
*/
struct var_real_list_83_
{
  // TI encoding
  word nelts;       // number of elements in the list
  RealNumber_83 *elts; // array of elements (Real)
};
typedef struct var_real_vector_83_ RealList_83;


/*
  This structure is used for storing a real matrix
*/
struct var_real_matrix_83_
{
  // TI encoding
  byte ncols;
  byte nrows;
  RealNumber_83 *elts; // array of elements (Real)
};
typedef struct var_real_matrix_83_ RealMatrix_83;


/*
  This structure is used to store an Y-equation object
*/
struct var_y_equation_83_
{
  word n_tokens;
  byte *tokens;
};
typedef struct var_y_equation_83_ YVariable_83;


/*
  This structure is used for storing a string
*/
struct var_string_83_
{
  // TI encoding
  word length;
  byte *string; //not zero terminated
};
typedef struct var_string_83_ String_83;


/*
  This structure is used for storing a Graphic Data Base object
*/
struct functions_83_
{
  byte flags;
  YVariable_83 fnct;
};

struct var_gdb_function_83_
{
  // TI encoding
  word length;
  byte unknown;
  byte mode_id;
  byte mode_settings;
  byte unused;
  byte ext_mode_settings;

  RealNumber_83 x_min;
  RealNumber_83 x_max;
  RealNumber_83 x_scl;
  RealNumber_83 y_min;
  RealNumber_83 y_max;
  RealNumber_83 y_scl;
  RealNumber_83 x_res;

  byte style[10];
  struct functions_83_ fnct_table[10];
};

struct var_gdb_polar_83_
{
  // TI encoding
  word length;
  byte unknown;
  byte mode_id;
  byte mode_settings;
  byte unused;
  byte ext_mode_settings;

  RealNumber_83 x_min;
  RealNumber_83 x_max;
  RealNumber_83 x_scl;
  RealNumber_83 y_min;
  RealNumber_83 y_max;
  RealNumber_83 y_scl;
  RealNumber_83 theta_min;
  RealNumber_83 theta_max;
  RealNumber_83 theta_step;
  
  byte style[6];
  struct functions_83_ fnct_table[6];
};

struct var_gdb_param_83_
{
  // TI encoding
  word length;
  byte unknown;
  byte mode_id;
  byte mode_settings;
  byte unused;
  byte ext_mode_settings;

  RealNumber_83 x_min;
  RealNumber_83 x_max;
  RealNumber_83 x_scl;
  RealNumber_83 y_min;
  RealNumber_83 y_max;
  RealNumber_83 y_scl;
  RealNumber_83 t_min;
  RealNumber_83 t_max;
  RealNumber_83 t_step;
  
  byte style[6];
  struct functions_83_ fnct_table[12];
};

struct var_gdb_seq_83_
{
  // TI encoding
  word length;
  byte unknown;
  byte mode_id;
  byte mode_settings;
  byte unused;
  byte ext_mode_settings;

  RealNumber_83 x_min;
  RealNumber_83 x_max;
  RealNumber_83 x_scl;
  RealNumber_83 y_min;
  RealNumber_83 y_max;
  RealNumber_83 y_scl;
  RealNumber_83 plot_start;
  RealNumber_83 n_max;
  RealNumber_83 un_min_1;
  RealNumber_83 vn_min_1;
  RealNumber_83 n_min;
  RealNumber_83 un_min_2;
  RealNumber_83 vn_min_2;
  RealNumber_83 wn_min_1;
  RealNumber_83 plot_step;
  RealNumber_83 wn_min_2;
  
  byte style[3];
  struct functions_83_ fnct_table[3];
};

union var_gdb_83_
{
  struct var_gdb_function_83_ fnct;
  struct var_gdb_polar_83_    polar;
  struct var_gdb_param_83_    param;
  struct var_gdb_seq_83_      seq;
};
typedef union var_gdb_83_ Gdb_83;

/*
  This structure is used for storing a picture object
*/
struct var_picture_83_
{
  // TI encoding
  word size;
  byte bitmap[1008];
};
typedef struct var_picture_83_ Picture_83;

/*
  This structure is used for storing a program object
*/
typedef YVariable_83 Program_83;

/*
  This structure is used for storing a Window Settings object
*/
struct var_wndsettings_normal_83_
{
  // TI encoding
  word unused;
  byte unknwown;
  RealNumber_83 x_min;
  RealNumber_83 x_max;
  RealNumber_83 x_scl;
  RealNumber_83 y_min;
  RealNumber_83 y_max;
  RealNumber_83 y_scl;
  RealNumber_83 theta_min;
  RealNumber_83 theta_max;
  RealNumber_83 theta_step;
  RealNumber_83 t_min;
  RealNumber_83 t_max;
  RealNumber_83 t_step;
  RealNumber_83 plot_start;
  RealNumber_83 n_max;
  RealNumber_83 un_min_1;
  RealNumber_83 vn_min_1;
  RealNumber_83 n_min;
  RealNumber_83 un_min_2;
  RealNumber_83 vn_min_2;
  RealNumber_83 wn_min_1;
  RealNumber_83 plot_step;
  RealNumber_83 x_res;
  RealNumber_83 wn_min_2;
};

struct var_wndsettings_saved_83_
{
  // TI encoding
  word unused;
  byte unknwown;
  RealNumber_83 x_min;
  RealNumber_83 x_max;
  RealNumber_83 x_scl;
  RealNumber_83 y_min;
  RealNumber_83 y_max;
  RealNumber_83 y_scl;
  RealNumber_83 theta_min;
  RealNumber_83 theta_max;
  RealNumber_83 theta_step;
  RealNumber_83 t_min;
  RealNumber_83 t_max;
  RealNumber_83 t_step;
  RealNumber_83 plot_start;
  RealNumber_83 n_max;
  RealNumber_83 un_min_1;
  RealNumber_83 vn_min_1;
  RealNumber_83 n_min;
  RealNumber_83 un_min_2;
  RealNumber_83 vn_min_2;
  RealNumber_83 wn_min_1;
  RealNumber_83 plot_step;
  RealNumber_83 x_res;
  RealNumber_83 wn_min_2;
};

union var_wndsettings_83_
{
  struct var_wndsettings_normal_83_ fnct;
  struct var_wndsettings_saved_83_    zsto;
};
typedef union var_wndsettings_83_ WndSettings_83;

/*
  This structure is used for storing a Table Settings object
*/
struct var_tblsettings_83_
{
  // TI encoding
  word unused;
  RealNumber_83 tbl_min;
  RealNumber_83 delta_tbl;
};

typedef struct var_tblsettings_83_ TblSettings_83;

#endif




