/*  tiffep - Ti File Format Engine & Proxy
 *  Copyright (C) 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_SOCK__
#define __TIFFEP_SOCK__

#include "tiffep.h"
#include "messages.h"

/**********************/
/* Socket abstraction */
/**********************/

/*
#if defined(__LINUX__)
  typedef int TiffepSock;
  typedef struct sockaddr_un TiffepSockAddr;
#elif defined(__WIN32__)
  typedef SOCKET TiffepSock;
  typedef struct sockaddr TiffepSockAddr;
#endif
*/

#if defined(__LINUX__)
struct Sock_
{
  int rfd; // file descriptor in reading
  int wfd; // file descriptor in writing
};
#elif defined(__WIN32__)
struct Sock_
{
  HANDLE rfd; // file descriptor in reading
  HANDLE wfd; // file descriptor in writing
};
#endif
typedef struct Sock_ TiffepSock;

/*************/
/* Functions */
/*************/

#define SERVER 1
#define CLIENT 2

/* 
   Create a socket
   - sd: a socket descriptor
   - server: server or client side
   Returns 0 if successful.
*/
TIEXPORT
int socket_create(TiffepSock *sd, int server);

/*
  Bind the socket: assign a name to it
  - sd: a socket descriptor
  - name: the address to assign to the socket
  Returns 0 if successful.
*/
TIEXPORT
int socket_bind(TiffepSock sd);

/*
	Listen the socket for connections
	- sd: a socket descriptor
	- max_log: the maximum number of authorized connections
	Returns 0 if successful
*/
TIEXPORT
int socket_listen(TiffepSock sd, int max_log);

/*
	Accept a connection from a socket
	- sd: a socket descriptor
	- name: return the address to assign the socket
	- nsd: return  the new socket descriptor
	Returns 0 if success.
*/
TIEXPORT
int socket_accept(TiffepSock sd, TiffepSock *nsd);

/*
	Send data to a socket
	- sd: a connected socket descriptor
	- data: data to send
	- len: length of data
	Return 0 if success.
*/
TIEXPORT
int socket_send(TiffepSock sd, void *data, int len);

/*
	Receive data from a socket
	- sd: a connected socket descriptor
	- data: data to receive
	- len: length of data buffer
	Return the number of received bytes.
*/
TIEXPORT
int socket_recv(TiffepSock sd, void *data, int len, int *read);

/*
	Connect the socket
	- sd: a socket descriptor
	- name: the address to assign to the socket
	Returns 0 if successful.
*/
TIEXPORT
int socket_connect(TiffepSock *sd);

TIEXPORT
int socket_send_msg(TiffepSock sd, TiffepMsg *m);
TIEXPORT
int socket_recv_msg(TiffepSock sd, TiffepMsg *m, int *read);

/* 
   Close a socket
   - sd: a socket descriptor
   Returns 0 if successful.
*/
TIEXPORT
int socket_close(TiffepSock sd);

#endif

