------------------------------------------------------------------------------
-- SIGNALS                                                                  --
--                                                                          --
-- Part of TextTools                                                        --
-- Designed and Programmed by Ken O. Burtch                                 --
--                                                                          --
------------------------------------------------------------------------------
--                                                                          --
--                 Copyright (C) 1999-2001 Ken O. Burtch                    --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- This is maintained at http://www.vaxxine.com/pegasoft                    --
--                                                                          --
------------------------------------------------------------------------------
with Ada.Interrupts.Names;
use  Ada.Interrupts, Ada.Interrupts.Names;

package Signals is

  Signal_PowerLow : boolean := false;
  pragma volatile( Signal_PowerLow );
  -- true if SIGPWR was received

  Signal_WindowChange : boolean := false;
  pragma volatile( Signal_WindowChange );
  -- true if SIGWINCH was received

  protected SignalHandlers is

     procedure HandlePowerFailure;
     pragma Attach_Handler( HandlePowerFailure, SIGPWR );

     procedure HandleWindowChange;
     pragma Attach_Handler( HandleWindowChange, SIGWINCH );

     procedure ResetPowerFailure;

     procedure ResetWindowChange;

  end SignalHandlers;

end Signals;

