/*
TerraLib - a library for developing GIS applications.
Copyright  2001, 2002, 2003 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular
purpose. The library provided hereunder is on an "as is" basis, and the
authors have no obligation to provide maintenance, support, updates,
enhancements, or modifications.
In no event shall INPE be held liable to any party
for direct, indirect, special, incidental, or consequential damages arising
out of the use of this library and its documentation.
*/

#ifndef TEPDIWAVELETATROUS_HPP
  #define TEPDIWAVELETATROUS_HPP

	#include "TePDIAlgorithm.hpp"

	#define waveletPlanes 2

  /**
   * @brief WaveletAtrous.
   * @author Felipe Castro da Silva <felipe@dpi.inpe.br>
   * @ingroup PDIWaveletsAlgorithms
   *
   * @note The required parameters are:
   *
   * @param input_raster (TePDITypes::TePDIRasterPtrType) - Input raster.
   * @param band (int) - Raster band.
   * @param levels (int) - Levels to decompose the raster.
   * @param filterType (TeFilterBanks) - Filter type.
   * @param multi_raster (TePDITypes::TePDIRasterPtrType) - ?
   * @param fit_histogram (bool) - ?
   * @param output_wavelets (TePDITypes::TePDIRasterVectorType) - ?
   * @param direction (TeWaveletAtrousDirection) - Direction.
   *
   */
  class TePDIWaveletAtrous : public TePDIAlgorithm {
    public :
      /** @enum TeWaveletAtrousDirection Decompose or Compose */
      enum TeWaveletAtrousDirection {DECOMPOSE, RECOMPOSE};
      /** @enum TeFilterBanks Filter Banks available */
      enum TeFilterBanks {B3SPLINE, SMALLB3SPLINE};

      /**
       * @brief Default Constructor.
       *
       */
      TePDIWaveletAtrous();

      /**
       * @brief Default Destructor
       */
      ~TePDIWaveletAtrous();

      /**
       * @brief Checks if the supplied parameters fits the requirements of each
       * PDI algorithm implementation.
       *
       * @note Error log messages must be generated. No exceptions generated.
       *
       * @param parameters The parameters to be checked.
       * @return true if the parameters are OK. false if not.
       */
      bool CheckParameters( const TePDIParameters& parameters ) const;
      
    protected :
      
      /**
       * @brief Decide the direction of the analysis based on the direction parameter.
       *
       * @return true if OK. false on error.
       */
      bool RunImplementation();

      /**
       * @brief Decomposition.
       *
       * @return true if OK. false on error.
       */
      bool RunImplementation_decompose();

      /**
       * @brief Recomposition.
       *
       * @return true if OK. false on error.
       */
      bool RunImplementation_recompose();

      /**
       * @brief Reset the internal state to the initial state.
       *
       * @param params The new parameters referente at initial state.
       */
      void ResetState( const TePDIParameters& params );
  };
  
/** @example TePDIWavelets_test.cpp
 *    Shows how to use this class.
 */    

#endif //TEPDIWaveletAtrous_HPP
