 
#include "TePDIGeoMosaicFactory.hpp"
#include "TePDIGeoMosaic.hpp"
#include <TeAgnostic.h>


TePDIGeoMosaicFactory::TePDIGeoMosaicFactory()
: TePDIAlgorithmFactory( std::string( "TePDIGeoMosaic" ) )
{
}


TePDIGeoMosaicFactory::~TePDIGeoMosaicFactory()
{
}


TePDIAlgorithm* TePDIGeoMosaicFactory::build ( const TePDIParameters& arg )
{
  TePDIAlgorithm* instance_ptr = new TePDIGeoMosaic();
  
  TEAGN_TRUE_OR_THROW( instance_ptr->Reset( arg ),
    "Invalid parameters" );
  
  return instance_ptr;
}
