/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

#ifndef  __TERRALIB_INTERNAL_QUERIER_DBSTR1_H
#define  __TERRALIB_INTERNAL_QUERIER_DBSTR1_H

#include "TeQuerierDB.h"

//! A class that implement a strategy to build STOs (Spatial Temporal Objects) from a TerraLib database (Strategy 1)
class TeQuerierDBStr1 : public TeQuerierDB
{

private:
		
		vector<string>				uniqueNames_;
		string						lastObjId_;
		int							geomId_;
		bool						isGroup_;			//! if the portal was built with statistics sql funcionts
		bool						groupInMemory_;		//! if it must group the object instances in the memory 
		string						linkName_;
		
		/* @name Internal functions to initialize portals */
		//@{
		bool initPortal(TeRepresentation& rep, TeTSEntry* ent=0);     
		bool initGeomPortal(TeRepresentation& rep, TeTSEntry* ent=0); 
		//@}

		/* @name Internal functions to fill the STOs from portals */
		//@{
		bool fillSTOGrouped(TeSTInstance& sto, bool fetchInstance = true);
		bool fillSTONoGrouped(TeSTInstance& sto);
		bool fillGeomSTO(TeSTInstance& sto, unsigned int index);
		//@}

public:

		//! Constructor
		TeQuerierDBStr1(TeQuerierParams& params) : 
			TeQuerierDB(params), 
			lastObjId_(""),
			isGroup_(false),
			groupInMemory_(false),
			linkName_("")
		{}
		
		//! Loads instances
		bool loadInstances(TeTSEntry* ent=0); 
		
		//! Returns each loaded instance
		bool fetchInstance(TeSTInstance&  sto); 

		//! Returns the number of instances to each time frame
		int numElemInstances(); 
};

//! A class that define a factory to build a querier strategy from database(strategy 1)
class TeQuerierDBStr1Factory : public TeQuerierImplFactory
{
public:

	//! Constructor
	TeQuerierDBStr1Factory(const string& name) : TeQuerierImplFactory(name) {}

	//! Builds a database querier
	virtual TeQuerierImpl* build (const TeQuerierParams& arg)
	{  
		TeQuerierParams tempArg = arg;
		return new TeQuerierDBStr1(tempArg); 
	}
};


#endif

